/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.core.mq.rocketmq.consumer;

import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.bean.ConsumerBean;
import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.FsConsumerModel;
import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.FsConsumerModelProperties;
import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.FsMessageListener;
import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.IFshowsConsumer;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.consumer.AliyunMessageListenerAdapter;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunFshowsConsumerImpl
implements IFshowsConsumer {
    private static final Logger log = LoggerFactory.getLogger(AliyunFshowsConsumerImpl.class);
    private ConsumerBean consumerBean;
    private FsConsumerModel fsConsumerModel;

    public AliyunFshowsConsumerImpl(ConsumerBean consumerBean, FsConsumerModel fsConsumerModel) {
        this.consumerBean = consumerBean;
        this.fsConsumerModel = fsConsumerModel;
    }

    @Override
    public void start() {
        this.consumerBean.start();
    }

    @Override
    public void shutdown() {
        this.consumerBean.shutdown();
    }

    @Override
    public void restart() {
        log.info("ark-spring-boot-starter >> \u6d88\u8d39\u8005\u5b9e\u4f8b\u201c{}\u201d\u5f00\u59cb\u91cd\u542f\uff01", (Object)this.fsConsumerModel.getConsumerProperties().getGroupId());
        if (this.consumerBean.isStarted()) {
            this.consumerBean.shutdown();
        }
        this.reloadConsumerConfig();
        this.consumerBean.start();
        log.info("ark-spring-boot-starter >> \u6d88\u8d39\u8005\u5b9e\u4f8b\u201c{}\u201d\u91cd\u542f\u5b8c\u6210\uff01", (Object)this.fsConsumerModel.getConsumerProperties().getGroupId());
    }

    public void reloadConsumerConfig() {
        FsConsumerModelProperties fsConsumerModelProperties = this.fsConsumerModel.getConsumerProperties();
        Properties properties = this.consumerBean.getProperties();
        properties.setProperty("AccessKey", fsConsumerModelProperties.getAccessKey());
        properties.setProperty("SecretKey", fsConsumerModelProperties.getSecretKey());
        properties.setProperty("maxReconsumeTimes", fsConsumerModelProperties.getMaxReconsumeTimes());
        properties.setProperty("ConsumeThreadNums", fsConsumerModelProperties.getConsumeThreadNums());
        properties.setProperty("consumeTimeout", fsConsumerModelProperties.getConsumeTimeout());
        this.consumerBean.setProperties(properties);
        log.info("ark-spring-boot-starter >> \u6d88\u8d39\u8005\u5b9e\u4f8b\u201c{}\u201d\u914d\u7f6e\u5237\u65b0\u6210\u529f\uff01\u5237\u65b0\u540e\u7684\u914d\u7f6e\u4e3a\uff1a{}", (Object)fsConsumerModelProperties.getGroupId(), (Object)properties);
    }

    @Override
    public void subscribe(String topic, String subExpression, FsMessageListener listener) {
        this.consumerBean.subscribe(topic, subExpression, (MessageListener)new AliyunMessageListenerAdapter(listener, this.fsConsumerModel));
    }

    @Override
    public void setFsConsumerModelProperties(FsConsumerModelProperties consumerProperties) {
        this.fsConsumerModel.setConsumerProperties(consumerProperties);
    }

    @Override
    public FsConsumerModel getConsumerModel() {
        return this.fsConsumerModel;
    }
}

