/**
 * fshows.com
 * Copyright (C) 2013-2019 All Rights Reserved.
 */
package com.fshows.ark.spring.boot.starter.util;

import com.fshows.ark.spring.boot.starter.constant.CommonConstant;
import com.fshows.ark.spring.boot.starter.core.mq.base.FsMqCustomConfig;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

/**
 * spring配置获取工具
 *
 * @author Liluqing
 * @version SpringPropertyUtil.java, v 0.1 2019-09-20 10:31
 */
public class ConfigUtil {

    /**
     * 获取配置
     *
     * @param el
     * @return
     */
    public static String getProperty(String el, ApplicationContext ctx) {
        if (isDynamicProperty(el)) {
            String result = ctx.getEnvironment().resolvePlaceholders(el);
            return isDynamicProperty(result) ? null : result;
        }
        return el;
    }

    /**
     * 是否外部动态配置
     *
     * @return
     */
    public static boolean isDynamicProperty(String key) {
        if (StringUtils.startsWithIgnoreCase(key, CommonConstant.DYNAMIC_PROPERTY_PREFIX2)
                && StringUtils.endsWithIgnoreCase(key, CommonConstant.DYNAMIC_PROPERTY_SUFFIX)) {
            return true;
        }
        return StringUtils.startsWithIgnoreCase(key, CommonConstant.DYNAMIC_PROPERTY_PREFIX)
                && StringUtils.endsWithIgnoreCase(key, CommonConstant.DYNAMIC_PROPERTY_SUFFIX);
    }

    /**
     * 获取配置的key
     *
     * @param el
     * @return
     */
    public static String isDynamicConfigKey(String el) {
        return isDynamicProperty(el) ? el : null;
    }

    /**
     * 获取配置的键名
     *
     * @param key
     * @return
     */
    public static String getDynamicKey(String key) {
        if (isDynamicProperty(key)) {
            int i = key.indexOf(":");
            if (i > -1) {
                return key.substring(2, i);
            }
            return key.substring(2, key.length() - 1);
        }
        return null;
    }

    /**
     * 用户自定义全局配置
     *
     * @param ctx
     * @return
     */
    public static FsMqCustomConfig getFsMqCustomConfig(ApplicationContext ctx) {
        try {
            return ctx.getBean(FsMqCustomConfig.class);
        } catch (Exception e) {
            return null;
        }
    }
}