/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package com.fshows.ark.spring.boot.starter.extend.mq.interceptor;

import com.fshows.ark.spring.boot.starter.constant.MQConstant;
import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage;
import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.FsConsumerInterceptor;
import com.fshows.ark.spring.boot.starter.util.StrUtil;
import com.fshows.ark.spring.boot.starter.util.TraceIdGenerator;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.MDC;
import org.springframework.core.annotation.Order;

import java.util.Map;

/**
 * 消费者拦截器
 *
 * @author liluqing
 * @version TradeIdConsumeInterceptor.java, v 0.1 2022-09-08 18:40
 */
@Slf4j
@Order(1)
public class TraceIdConsumeInterceptor implements FsConsumerInterceptor {

    @Override
    public void beforeConsume(FsMessage fsMessage) {
        Map<Object, Object> extendMap = fsMessage.getExtendParam();
        if (extendMap != null) {
            String traceId = extendMap.get(MQConstant.TRACE_ID) == null ?
                    TraceIdGenerator.generate() : (String) extendMap.get(MQConstant.TRACE_ID);
            MDC.put(MQConstant.TRACE_ID, traceId);
        }
    }

    @Override
    public void afterConsume(FsMessage fsMessage, boolean consumeResult) {
        MDC.remove(MQConstant.TRACE_ID);
    }
}
