/**
 * fshows.com
 * Copyright (C) 2013-2019 All Rights Reserved.
 */
package com.fshows.ark.spring.boot.starter.core.mq.base;

import lombok.Data;

import java.util.Map;

/**
 * 消息体
 *
 * @author Liluqing
 * @version FsMessage.java, v 0.1 2019-07-08 15:30
 */
@Data
public class FsMessage {

    /**
     * 消息主体
     */
    private String topic;

    /**
     * 消息TAG
     */
    private String tag;

    /**
     * 消息key
     */
    private String key;

    /**
     * 字符串消息内容,在contentBody为null的情况下才会使用该消息体
     */
    private String content;

    /**
     * 消息内容byte[], 如果该属性有值，则优先使用该属性作为作为消息体
     */
    private byte[] contentBody;

    /**
     * 定时发送,设置发送的时间
     */
    private Long sendTime;

    /**
     * 消息消费时, 消息已经被重试消费的次数
     * (仅消费时，才存在该属性)
     */
    private int reconsumeTimes;

    /**
     * 事务消息ID
     */
    private String transactionMessageId;

    /**
     * 拓展参数
     */
    private Map<Object, Object> extendParam;

    public FsMessage() {
    }

    public FsMessage(String key, String content) {
        this.key = key;
        this.content = content;
    }

    public void setContent(String content) {
        // 两个消息体只有一个有效
        this.content = content;
        this.contentBody = null;
    }

    public void setContentBody(byte[] contentBody) {
        // 两个消息体只有一个有效
        this.contentBody = contentBody;
        this.content = null;
    }
}