/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.annotation.mq;

import org.springframework.core.annotation.AliasFor;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 *
 * @author liluqing
 * @version RocketMessage.java, v 0.1 2021-08-12 19:54
 */
@RocketMessage
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.ANNOTATION_TYPE})
@Inherited
public @interface RocketMessageAsync {

    /**
     * 生产者组
     *
     * @return
     */
    @AliasFor(annotation = RocketMessage.class)
    String topic() default "";

    /**
     * msg key前缀
     *  （消息的key都会默认添加该前缀）
     *
     * @return
     */
    String msgKeyPrefix() default "";


    /**
     * 生产者组
     *
     * @return
     */
    @AliasFor(annotation = RocketMessage.class)
    String tag() default "";

    /**
     * 延迟投递时间
     *
     * @return
     */
    String delayTime() default "0";
}