/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.util;

import com.fshows.ark.spring.boot.starter.util.LogUtil;
import com.fshows.ark.spring.boot.starter.util.StrUtil;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceIdGenerator {
    private static final Logger log = LoggerFactory.getLogger(TraceIdGenerator.class);
    private static String IP_16 = "ffffffff";
    private static AtomicInteger count = new AtomicInteger(1000);
    private static String P_ID_CACHE = null;

    private static String getTraceId(String ip, long timestamp, int nextId) {
        StringBuilder appender = new StringBuilder(30);
        appender.append(ip).append(timestamp).append(nextId).append(TraceIdGenerator.getPID());
        return appender.toString();
    }

    public static String generate() {
        return TraceIdGenerator.getTraceId(IP_16, System.currentTimeMillis(), TraceIdGenerator.getNextId());
    }

    private static String getIP_16(String ip) {
        String[] ips = ip.split("\\.");
        StringBuilder sb = new StringBuilder();
        for (String column : ips) {
            String hex = Integer.toHexString(Integer.parseInt(column));
            if (hex.length() == 1) {
                sb.append('0').append(hex);
                continue;
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    private static int getNextId() {
        int next;
        int current;
        while (!count.compareAndSet(current, next = (current = count.get()) > 9000 ? 1000 : current + 1)) {
        }
        return next;
    }

    private static String getInetAddress() {
        Enumeration<NetworkInterface> interfaces = null;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress address = null;
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    address = addresses.nextElement();
                    if (address.isLoopbackAddress() || address.getHostAddress().indexOf(58) != -1) continue;
                    return address.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            LogUtil.error(log, "\u83b7\u53d6IP\u5730\u5740SocketException\u5f02\u5e38,e={}", e);
        }
        catch (NullPointerException e) {
            LogUtil.error(log, "\u83b7\u53d6IP\u5730\u5740NullPointerException\u5f02\u5e38,e={}", e);
        }
        return null;
    }

    private static String getPID() {
        if (P_ID_CACHE != null) {
            return P_ID_CACHE;
        }
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        if (StrUtil.isBlank(processName)) {
            return "";
        }
        String[] processSplitName = processName.split("@");
        if (processSplitName.length == 0) {
            return "";
        }
        String pid = processSplitName[0];
        if (StrUtil.isBlank(pid)) {
            return "";
        }
        P_ID_CACHE = pid;
        return pid;
    }

    static {
        String ipAddress = TraceIdGenerator.getInetAddress();
        if (ipAddress != null) {
            IP_16 = TraceIdGenerator.getIP_16(ipAddress);
        }
    }
}

