/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.extend.mq.configlistener;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.fshows.ark.spring.boot.starter.extend.mq.configlistener.ConfigChangeModel;
import com.fshows.ark.spring.boot.starter.extend.mq.configlistener.ConsumeConfigChangeListener;
import com.fshows.ark.spring.boot.starter.extend.mq.configlistener.ProducerConfigChangeListener;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;

public class ApolloConfigServicesListener
implements ApplicationRunner {
    @Autowired
    private ConsumeConfigChangeListener consumeConfigChangeListener;
    @Autowired
    private ProducerConfigChangeListener producerConfigChangeListener;
    private ExecutorService executorService = Executors.newFixedThreadPool(1);

    public void run(ApplicationArguments args) {
        Config config = ConfigService.getAppConfig();
        config.addChangeListener(changeEvent -> {
            ArrayList<ConfigChangeModel> configChangeModelList = new ArrayList<ConfigChangeModel>();
            for (String key : changeEvent.changedKeys()) {
                ConfigChange change = changeEvent.getChange(key);
                configChangeModelList.add(this.convertConfigChangeModel(change));
            }
            this.executorService.execute(() -> this.consumeConfigChangeListener.reloadConfig(configChangeModelList));
            this.executorService.execute(() -> this.producerConfigChangeListener.reloadConfig(configChangeModelList));
        });
    }

    public ConfigChangeModel convertConfigChangeModel(ConfigChange change) {
        ConfigChangeModel configChangeModel = new ConfigChangeModel();
        configChangeModel.setKey(change.getPropertyName());
        configChangeModel.setOldValue(change.getOldValue());
        configChangeModel.setNewValue(change.getNewValue());
        return configChangeModel;
    }
}

