/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer;

import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsMessageSendContext;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsProducerInvoke;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsProducerModel;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendErrorCallback;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendResult;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendSuccessCallback;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.IFshowsProducer;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.IProducerConfigUpdateHandler;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.IProducerProxyFactory;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.TransactionMessageManage;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.RocketSendMessageMethodModel;
import com.fshows.ark.spring.boot.starter.enums.ProducerReturnTypeEnum;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketProducerProxyHandler
implements InvocationHandler,
IProducerConfigUpdateHandler {
    private static final Logger log = LoggerFactory.getLogger(RocketProducerProxyHandler.class);
    private static final ScheduledExecutorService delayedShutdownExecutor = Executors.newScheduledThreadPool(2, r -> {
        Thread t = new Thread(r, "producer-delayed-shutdown");
        t.setDaemon(true);
        return t;
    });
    private static final long DELAYED_SHUTDOWN_MILLIS = 15000L;
    private final AtomicReference<IFshowsProducer> producerRef;
    private IProducerProxyFactory producerProxyFactory;
    private TransactionMessageManage transactionMessageManage;
    private FsProducerModel fsProducerModel;
    private Map<Method, RocketSendMessageMethodModel> sendMessageMethodMap;

    public RocketProducerProxyHandler(IFshowsProducer producer, FsProducerModel fsProducerModel, TransactionMessageManage transactionMessageManage, IProducerProxyFactory producerProxyFactory) {
        this.producerRef = new AtomicReference<IFshowsProducer>(producer);
        this.sendMessageMethodMap = fsProducerModel.getSendMessageMethodModelMap();
        this.fsProducerModel = fsProducerModel;
        this.transactionMessageManage = transactionMessageManage;
        this.producerProxyFactory = producerProxyFactory;
    }

    @Override
    public void restart() {
        log.info("ark-spring-boot-starter >> \u5f00\u59cb\u66f4\u65b0\u751f\u4ea7\u8005\u5b9e\u4f8b\uff01");
        IFshowsProducer newProducer = this.producerProxyFactory.getFshowsProducer(this.fsProducerModel, this.transactionMessageManage);
        newProducer.start();
        IFshowsProducer oldProducer = this.producerRef.getAndSet(newProducer);
        if (oldProducer != null) {
            log.info("ark-spring-boot-starter >> \u751f\u4ea7\u8005\u5b9e\u4f8b\u5df2\u66f4\u65b0\uff0c\u65e7\u5b9e\u4f8b\u5c06\u5728{}\u79d2\u540e\u5173\u95ed", (Object)15L);
            delayedShutdownExecutor.schedule(() -> {
                try {
                    oldProducer.shutdown();
                    log.info("ark-spring-boot-starter >> \u65e7\u751f\u4ea7\u8005\u5b9e\u4f8b\u5df2\u6210\u529f\u5173\u95ed");
                }
                catch (Exception e) {
                    log.error("ark-spring-boot-starter >> \u5173\u95ed\u65e7\u751f\u4ea7\u8005\u5b9e\u4f8b\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                }
            }, 15000L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Object.class.equals(method.getDeclaringClass())) {
            return method.invoke((Object)this, args);
        }
        IFshowsProducer producer = this.producerRef.get();
        if (producer == null) {
            throw new IllegalStateException("\u751f\u4ea7\u8005\u5b9e\u4f8b\u4e3anull\uff0c\u65e0\u6cd5\u53d1\u9001\u6d88\u606f");
        }
        RocketSendMessageMethodModel sendMessageMethod = this.sendMessageMethodMap.get(method);
        FsMessageSendContext messageSendcontext = this.buildMessageSendContext(sendMessageMethod, args);
        FsSendResult sendResult = this.sendMessage(messageSendcontext, producer);
        return ProducerReturnTypeEnum.VOID.equals((Object)sendMessageMethod.getReturnTypeEnum()) ? null : sendResult;
    }

    @Override
    public IFshowsProducer getProducer() {
        return this.producerRef.get();
    }

    @Override
    public TransactionMessageManage getTransactionMessageManage() {
        return this.transactionMessageManage;
    }

    @Override
    public FsProducerModel getFsProducerModel() {
        return this.fsProducerModel;
    }

    private FsSendResult sendMessage(FsMessageSendContext messageSendcontext, IFshowsProducer producer) {
        FsSendResult sendResult = producer.send(messageSendcontext);
        return sendResult;
    }

    private FsMessageSendContext buildMessageSendContext(RocketSendMessageMethodModel rocketSendMessageMethodModel, Object[] args) {
        FsMessageSendContext context = new FsMessageSendContext();
        context.setRocketSendMessageMethodModel(rocketSendMessageMethodModel);
        context.setProducerSendTypeEnum(rocketSendMessageMethodModel.getSendTypeEnum());
        context.setProducerTypeEnum(rocketSendMessageMethodModel.getProducerTypeEnum());
        FsProducerInvoke producerInvoke = rocketSendMessageMethodModel.getParamTypeEnum().getFsProducerInvoke();
        FsSendSuccessCallback successCallback = producerInvoke.buildFsSendSuccessCallback(rocketSendMessageMethodModel, args);
        context.setSuccessCallback(successCallback);
        FsSendErrorCallback errorCallback = producerInvoke.buildFsSendErrorCallback(rocketSendMessageMethodModel, args);
        context.setErrorCallback(errorCallback);
        FsMessage fsMessage = producerInvoke.buildFsMessage(rocketSendMessageMethodModel, args);
        context.setFsMessage(fsMessage);
        return context;
    }
}

