/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer;

import com.aliyun.openservices.ons.api.bean.ProducerBean;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsProducerModel;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.IFshowsProducer;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.TransactionMessageManage;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.interceptor.IProducerInterceptorManagement;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.AbstractProducerProxyFactory;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.AliyunFshowsProducerImpl;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.RocketProducerProxyHandler;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.SimpleFshowsProducerImpl;
import com.fshows.ark.spring.boot.starter.exception.MQConsumerException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class DefaultProducerProxyFactoryImpl
extends AbstractProducerProxyFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultProducerProxyFactoryImpl.class);
    private IProducerInterceptorManagement producerInterceptorManagement;
    private Map<String, ProducerBean> aliyunProducerBeanMap = null;

    @Override
    public <T> T buildProducerProxy(IFshowsProducer fshowsProducer, TransactionMessageManage transactionMessageManage, FsProducerModel producerModel, Class<T> producerInterface) {
        RocketProducerProxyHandler producerProxyHandler = new RocketProducerProxyHandler(fshowsProducer, producerModel, transactionMessageManage, this);
        Object instance = Proxy.newProxyInstance(producerInterface.getClassLoader(), new Class[]{producerInterface}, (InvocationHandler)producerProxyHandler);
        return (T)instance;
    }

    @Override
    public IFshowsProducer createIFshowsProducer(FsProducerModel fsProducerModel, TransactionMessageManage transactionMessageManage) {
        ProducerBean producerBean;
        if (this.aliyunProducerBeanMap == null) {
            this.aliyunProducerBeanMap = this.getProducerBeanMapForCtx(this.applicationContext);
        }
        if ((producerBean = this.aliyunProducerBeanMap.get(fsProducerModel.getGroupId())) == null) {
            producerBean = this.createProducerBean(fsProducerModel);
        }
        producerBean.start();
        AliyunFshowsProducerImpl iFshowsProducer = new AliyunFshowsProducerImpl(producerBean, fsProducerModel.getCharsetName(), this.producerInterceptorManagement.getProducerInterceptorActuator(), transactionMessageManage);
        return iFshowsProducer;
    }

    @Override
    public IFshowsProducer createSimpleFshowsProducer(FsProducerModel fsProducerModel) {
        ProducerBean producerBean;
        if (this.aliyunProducerBeanMap == null) {
            this.aliyunProducerBeanMap = this.getProducerBeanMapForCtx(this.applicationContext);
        }
        if ((producerBean = this.aliyunProducerBeanMap.get(fsProducerModel.getGroupId())) == null) {
            producerBean = this.createProducerBean(fsProducerModel);
        }
        producerBean.start();
        SimpleFshowsProducerImpl iFshowsProducer = new SimpleFshowsProducerImpl(producerBean, fsProducerModel.getCharsetName());
        return iFshowsProducer;
    }

    private ProducerBean createProducerBean(FsProducerModel fsProducerModel) {
        ProducerBean producerBean = new ProducerBean();
        Properties properties = new Properties();
        properties.setProperty("GROUP_ID", fsProducerModel.getGroupId());
        properties.setProperty("AccessKey", fsProducerModel.getAccessKey());
        properties.setProperty("SecretKey", fsProducerModel.getSecretKey());
        properties.setProperty("NAMESRV_ADDR", fsProducerModel.getNamesrvAddr());
        properties.setProperty("SendMsgTimeoutMillis", fsProducerModel.getSendMsgTimeoutMillis());
        producerBean.setProperties(properties);
        return producerBean;
    }

    private Map<String, ProducerBean> getProducerBeanMapForCtx(ApplicationContext ctx) {
        Map producerBeanMap = ctx.getBeansOfType(ProducerBean.class);
        if (producerBeanMap == null || producerBeanMap.size() == 0) {
            return new ConcurrentHashMap<String, ProducerBean>();
        }
        ConcurrentHashMap<String, ProducerBean> groupProducerBeanMap = new ConcurrentHashMap<String, ProducerBean>(producerBeanMap.size());
        for (Map.Entry entry : producerBeanMap.entrySet()) {
            Properties properties = ((ProducerBean)entry.getValue()).getProperties();
            if (properties == null) {
                log.error("ark-spring-boot-starter >> \u81ea\u5b9a\u4e49producerBean\u7684\u53c2\u6570\u672a\u8bbe\u7f6e! beanName={}", entry.getKey());
                throw new MQConsumerException("ark-spring-boot-starter >> rocketmq\u751f\u4ea7\u8005\u8005\u521b\u5efa\u5931\u8d25\uff01");
            }
            String key = properties.getProperty("GROUP_ID") == null ? properties.getProperty("ProducerId") : properties.getProperty("GROUP_ID");
            groupProducerBeanMap.put(key, (ProducerBean)entry.getValue());
        }
        return groupProducerBeanMap;
    }

    public void setProducerInterceptorManagement(IProducerInterceptorManagement producerInterceptorManagement) {
        this.producerInterceptorManagement = producerInterceptorManagement;
    }
}

