/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer;

import cn.hutool.core.util.ReflectUtil;
import com.fshows.ark.spring.boot.starter.annotation.mq.RocketMessage;
import com.fshows.ark.spring.boot.starter.annotation.mq.RocketMessageAsync;
import com.fshows.ark.spring.boot.starter.annotation.mq.RocketProducer;
import com.fshows.ark.spring.boot.starter.annotation.mq.TransactionMessage;
import com.fshows.ark.spring.boot.starter.core.mq.base.FsMqCustomConfig;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsProducerConfigUpdateModel;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsProducerModel;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.IFshowsProducer;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.IProducerConfigUpdateHandler;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.IProducerProxyFactory;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.TransactionMessageManage;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.RocketSendMessageMethodModel;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.transaction.TransactionMessageMethodModel;
import com.fshows.ark.spring.boot.starter.enums.ProducerParamTypeEnum;
import com.fshows.ark.spring.boot.starter.enums.ProducerReturnTypeEnum;
import com.fshows.ark.spring.boot.starter.enums.ProducerSendTypeEnum;
import com.fshows.ark.spring.boot.starter.enums.ProducerTypeEnum;
import com.fshows.ark.spring.boot.starter.exception.MQProducerException;
import com.fshows.ark.spring.boot.starter.util.ConfigUtil;
import com.fshows.ark.spring.boot.starter.util.NumberUtil;
import com.fshows.ark.spring.boot.starter.util.StrUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.omg.CORBA.Object;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@RocketProducer
public abstract class AbstractProducerProxyFactory
implements IProducerProxyFactory,
ApplicationContextAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractProducerProxyFactory.class);
    protected ApplicationContext applicationContext;
    protected final Map<String, IFshowsProducer> fsProducerCacheMap = new ConcurrentHashMap<String, IFshowsProducer>();
    private final Map<String, Set<FsProducerConfigUpdateModel>> configKeyToProxyHandlerMap = new ConcurrentHashMap<String, Set<FsProducerConfigUpdateModel>>();

    @Override
    public Map<String, Set<FsProducerConfigUpdateModel>> getFsProducerConfigUpdateModelMap() {
        return this.configKeyToProxyHandlerMap;
    }

    private void registerConfigKeyMapping(String configKey, FsProducerConfigUpdateModel producerConfigUpdateModel) {
        this.configKeyToProxyHandlerMap.computeIfAbsent(configKey, k -> ConcurrentHashMap.newKeySet()).add(producerConfigUpdateModel);
    }

    @Override
    public <T> T bulidRocketProducerProxy(Class<T> producerInterface) {
        FsProducerModel producerModel = this.resolveProducerInterface(producerInterface, this.applicationContext);
        TransactionMessageManage transactionMessageManage = this.getTransactionMessageManage(this.applicationContext);
        IFshowsProducer fshowsProducer = this.getFshowsProducer(producerModel, transactionMessageManage);
        T instance = this.buildProducerProxy(fshowsProducer, transactionMessageManage, producerModel, producerInterface);
        this.registerConfigKeyMapping(instance);
        return instance;
    }

    public <T> void registerConfigKeyMapping(T instance) {
        InvocationHandler handler = Proxy.getInvocationHandler(instance);
        if (handler instanceof IProducerConfigUpdateHandler) {
            FsProducerConfigUpdateModel accessKeyModel;
            IProducerConfigUpdateHandler proxyHandler = (IProducerConfigUpdateHandler)((java.lang.Object)handler);
            FsProducerModel producerModel = proxyHandler.getFsProducerModel();
            if (ConfigUtil.isDynamicProperty(producerModel.getOriginalAccessKey())) {
                accessKeyModel = new FsProducerConfigUpdateModel();
                accessKeyModel.setKey(ConfigUtil.getDynamicKey(producerModel.getOriginalAccessKey()));
                accessKeyModel.setTarget(producerModel);
                accessKeyModel.setField(ReflectUtil.getField(producerModel.getClass(), (String)"accessKey"));
                accessKeyModel.setConfigUpdateHandler(proxyHandler);
                this.registerConfigKeyMapping(ConfigUtil.getDynamicKey(producerModel.getOriginalAccessKey()), accessKeyModel);
            }
            if (ConfigUtil.isDynamicProperty(producerModel.getOriginalSecretKey())) {
                accessKeyModel = new FsProducerConfigUpdateModel();
                accessKeyModel.setKey(ConfigUtil.getDynamicKey(producerModel.getOriginalSecretKey()));
                accessKeyModel.setTarget((Object)producerModel);
                accessKeyModel.setField(ReflectUtil.getField(producerModel.getClass(), (String)"secretKey"));
                accessKeyModel.setConfigUpdateHandler(proxyHandler);
                this.registerConfigKeyMapping(ConfigUtil.getDynamicKey(producerModel.getOriginalSecretKey()), accessKeyModel);
            }
            log.debug("ark-spring-boot-starter >> \u5df2\u6ce8\u518c\u751f\u4ea7\u8005\u4ee3\u7406Handler\u7684\u914d\u7f6e\u6620\u5c04\u5173\u7cfb: {}", (java.lang.Object)producerModel.getOriginalAccessKey());
        }
    }

    public TransactionMessageManage getTransactionMessageManage(ApplicationContext ctx) {
        Map map;
        block3: {
            try {
                map = ctx.getBeansOfType(TransactionMessageManage.class);
                if (map.size() != 0) break block3;
                return null;
            }
            catch (Exception e) {
                log.warn("ark-spring-boot-starter >> \u5f53\u524d\u5e94\u7528\u672a\u914d\u7f6eTransactionMessageManage,\u6682\u65e0\u6cd5\u4f7f\u7528\u4e8b\u52a1\u6d88\u606f\u529f\u80fd\uff01");
                return null;
            }
        }
        return (TransactionMessageManage)map.entrySet().iterator().next().getValue();
    }

    @Override
    public IFshowsProducer getFshowsProducer(FsProducerModel fsProducerModel, TransactionMessageManage transactionMessageManage) {
        if (this.fsProducerCacheMap.containsKey(fsProducerModel.getGroupId())) {
            return this.fsProducerCacheMap.get(fsProducerModel.getGroupId());
        }
        IFshowsProducer fshowsProducer = this.createIFshowsProducer(fsProducerModel, transactionMessageManage);
        this.fsProducerCacheMap.put(fsProducerModel.getGroupId(), fshowsProducer);
        return fshowsProducer;
    }

    public abstract IFshowsProducer createSimpleFshowsProducer(FsProducerModel var1);

    public abstract <T> T buildProducerProxy(IFshowsProducer var1, TransactionMessageManage var2, FsProducerModel var3, Class<T> var4);

    protected abstract IFshowsProducer createIFshowsProducer(FsProducerModel var1, TransactionMessageManage var2);

    protected FsProducerModel resolveProducerInterface(Class producerInterface, ApplicationContext ctx) {
        Method[] methods;
        String aliyunSecretKey;
        RocketProducer producerAnnotation = producerInterface.getAnnotation(RocketProducer.class);
        FsMqCustomConfig fsMqCustomConfig = ConfigUtil.getFsMqCustomConfig(ctx);
        String aliyunAccessKey = fsMqCustomConfig != null && "${ark.aliyun.access-key:none}".equals(producerAnnotation.accessKey()) ? fsMqCustomConfig.getAliyunAccessKey() : producerAnnotation.accessKey();
        String string = aliyunSecretKey = fsMqCustomConfig != null && "${ark.aliyun.secret-key:none}".equals(producerAnnotation.secretKey()) ? fsMqCustomConfig.getAliyunSecretKey() : producerAnnotation.secretKey();
        if (fsMqCustomConfig != null && "${ark.aliyun.access-key:none}".equals(producerAnnotation.accessKey())) {
            log.debug("ark-spring-boot-starter >> \u4f7f\u7528\u81ea\u5b9a\u4e49\u5168\u5c40aliyunAccessKey,\u521d\u59cb\u5316\u751f\u4ea7\u8005 >> aliyunAccessKey={}", (java.lang.Object)aliyunAccessKey);
        }
        FsProducerModel fsProducerModel = new FsProducerModel();
        fsProducerModel.setProducerClass(producerInterface);
        fsProducerModel.setGroupId(ConfigUtil.getProperty(producerAnnotation.groupId(), ctx));
        fsProducerModel.setSendMsgTimeoutMillis(ConfigUtil.getProperty(producerAnnotation.sendMsgTimeoutMillis(), ctx));
        fsProducerModel.setCharsetName(ConfigUtil.getProperty(producerAnnotation.msgContentCharset(), ctx));
        fsProducerModel.setAccessKey(ConfigUtil.getProperty(aliyunAccessKey, ctx));
        fsProducerModel.setSecretKey(ConfigUtil.getProperty(aliyunSecretKey, ctx));
        fsProducerModel.setOriginalAccessKey(aliyunAccessKey);
        fsProducerModel.setOriginalSecretKey(aliyunSecretKey);
        fsProducerModel.setOriginalSendMsgTimeoutMillis(producerAnnotation.sendMsgTimeoutMillis());
        fsProducerModel.setNamesrvAddr(ConfigUtil.getProperty(producerAnnotation.namesrvAddr(), ctx));
        HashMap<Method, RocketSendMessageMethodModel> sendMessageMethodModelMap = new HashMap<Method, RocketSendMessageMethodModel>();
        Method[] methodArray = methods = producerInterface.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            RocketSendMessageMethodModel messageMethodModel = this.resolveRocketMessage(ctx, producerAnnotation, m);
            if (messageMethodModel == null) {
                messageMethodModel = this.resolveRocketMessageAsync(ctx, producerAnnotation, m);
            }
            if (messageMethodModel == null) {
                log.error("ark-spring-boot-starter >> {}\u65b9\u6cd5\u6ca1\u6709\u6807\u6ce8@RocketMessage\u6216\u8005@RocketMessageAsync\u6ce8\u89e3,\u751f\u4ea7\u8005\u81ea\u52a8\u5316\u914d\u7f6e\u5931\u8d25", (java.lang.Object)m);
                throw new MQProducerException("ark-spring-boot-starter >> \u68c0\u6d4b\u5230" + m + "\u65b9\u6cd5\u6ca1\u6709\u6807\u6ce8@RocketMessage\u6216\u8005@RocketMessageAsync\u6ce8\u89e3\u7684\u65b9\u6cd5");
            }
            sendMessageMethodModelMap.put(m, messageMethodModel);
            ++n2;
        }
        fsProducerModel.setSendMessageMethodModelMap(sendMessageMethodModelMap);
        this.checkFsProducerModel(fsProducerModel, ctx);
        return fsProducerModel;
    }

    protected void checkFsProducerModel(FsProducerModel fsProducerModel, ApplicationContext ctx) {
        String className = fsProducerModel.getProducerClass().getName();
        if (StrUtil.isEmpty(fsProducerModel.getGroupId())) {
            log.error("ark-spring-boot-starter >> {}\u63a5\u53e3\u6807\u6ce8\u6ca1\u6709\u8bbe\u7f6egroupId", (java.lang.Object)className);
            throw new MQProducerException("ark-spring-boot-starter >> \u68c0\u6d4b\u5230" + className + "\u7c7b\u7684@RocketProducer\u6ce8\u89e3\u6ca1\u6709\u8bbe\u7f6egroupId\u6216\u914d\u7f6e\u9879\u672a\u914d\u7f6e");
        }
        if (StrUtil.isEmpty(fsProducerModel.getNamesrvAddr())) {
            log.error("ark-spring-boot-starter >> \u68c0\u6d4b\u5230mq name server\u5730\u5740\u914d\u7f6e\u9879'ark.mq.name-server'\u672a\u914d\u7f6e");
            throw new MQProducerException("ark-spring-boot-starter >> \u68c0\u6d4b\u5230mq name server\u5730\u5740\u914d\u7f6e\u9879'ark.mq.name-server'\u672a\u914d\u7f6e");
        }
        if (!NumberUtil.isNumber(fsProducerModel.getSendMsgTimeoutMillis())) {
            log.error("ark-spring-boot-starter >> \u68c0\u6d4b\u5230\u751f\u4ea7\u8005'{}'\u7c7b\u7684sendMsgTimeoutMillis\u5c5e\u6027\u4e3a\u975e\u6570\u5b57", (java.lang.Object)className);
            throw new MQProducerException("ark-spring-boot-starter >> \u68c0\u6d4b\u5230\u751f\u4ea7\u8005'" + className + "'\u7c7b\u7684sendMsgTimeoutMillis\u5c5e\u6027\u4e3a\u975e\u6570\u5b57");
        }
        Map<Method, RocketSendMessageMethodModel> sendMessageMethodModelMap = fsProducerModel.getSendMessageMethodModelMap();
        if (sendMessageMethodModelMap == null || sendMessageMethodModelMap.size() == 0) {
            return;
        }
        for (Map.Entry<Method, RocketSendMessageMethodModel> entry : sendMessageMethodModelMap.entrySet()) {
            RocketSendMessageMethodModel messageMethodModel = entry.getValue();
            Method interfaceMethod = messageMethodModel.getInterfaceMethod();
            String methodPath = String.valueOf(className) + "." + interfaceMethod.getName();
            if (StrUtil.isEmpty(messageMethodModel.getTopic())) {
                log.error("ark-spring-boot-starter >> \u68c0\u6d4b\u5230\u751f\u4ea7\u8005\u65b9\u6cd5'{}'\u7684topic\u5c5e\u6027\u672a\u8bbe\u7f6e", (java.lang.Object)methodPath);
                throw new MQProducerException("ark-spring-boot-starter >> \u68c0\u6d4b\u5230\u751f\u4ea7\u8005\u65b9\u6cd5'" + methodPath + "'\u7684topic\u5c5e\u6027\u672a\u8bbe\u7f6e\u6216\u914d\u7f6e\u9879\u672a\u914d\u7f6e");
            }
            if (StrUtil.isEmpty(messageMethodModel.getTag())) {
                log.error("ark-spring-boot-starter >> \u68c0\u6d4b\u5230\u751f\u4ea7\u8005\u65b9\u6cd5'{}'\u7684tag\u5c5e\u6027\u672a\u8bbe\u7f6e", (java.lang.Object)methodPath);
                throw new MQProducerException("ark-spring-boot-starter >> \u68c0\u6d4b\u5230\u751f\u4ea7\u8005\u65b9\u6cd5'" + methodPath + "'\u7684tag\u5c5e\u6027\u672a\u8bbe\u7f6e\u6216\u914d\u7f6e\u9879\u672a\u914d\u7f6e");
            }
            if (!NumberUtil.isNumber(messageMethodModel.getDelayTime())) {
                log.error("ark-spring-boot-starter >> \u68c0\u6d4b\u5230\u751f\u4ea7\u8005\u65b9\u6cd5'{}'\u7684delayTime\u5c5e\u6027\u4e3a\u975e\u6570\u5b57", (java.lang.Object)methodPath);
                throw new MQProducerException("ark-spring-boot-starter >> \u68c0\u6d4b\u5230\u751f\u4ea7\u8005\u65b9\u6cd5'" + methodPath + "'\u7684delayTime\u5c5e\u6027\u4e3a\u975e\u6570");
            }
            this.checkTransactionMsgConfig(messageMethodModel, methodPath, ctx);
        }
    }

    private void checkTransactionMsgConfig(RocketSendMessageMethodModel messageMethodModel, String methodPath, ApplicationContext ctx) {
        if (!ProducerTypeEnum.TRANSACTION_MESSAGE_PRODUCER.equals((java.lang.Object)messageMethodModel.getProducerTypeEnum())) {
            return;
        }
        if (!ProducerSendTypeEnum.SYNC.equals((java.lang.Object)messageMethodModel.getSendTypeEnum())) {
            log.error("ark-spring-boot-starter >> \u4e8b\u52a1\u6d88\u606f\u53ea\u652f\u6301ProducerSendTypeEnum.SYNC(\u540c\u6b65\u53d1\u9001\u65b9\u5f0f),\u65b9\u6cd5'{}'\u914d\u7f6e\u6709\u8bef", (java.lang.Object)methodPath);
            throw new MQProducerException("ark-spring-boot-starter >> \u4e8b\u52a1\u6d88\u606f\u53ea\u652f\u6301ProducerSendTypeEnum.SYNC(\u540c\u6b65\u53d1\u9001\u65b9\u5f0f),\u65b9\u6cd5'" + methodPath + "'\u914d\u7f6e\u6709\u8bef");
        }
        if (messageMethodModel.getTransactionMessageMethodModel() == null || !NumberUtil.isNumber(messageMethodModel.getTransactionMessageMethodModel().getTransactionLocalTimeOut())) {
            log.error("ark-spring-boot-starter >> \u68c0\u6d4b\u5230\u751f\u4ea7\u8005\u4e8b\u52a1\u6d88\u606f\u65b9\u6cd5'{}'\u7684transactionLocalTimeOut\u5c5e\u6027\u672a\u8bbe\u7f6e", (java.lang.Object)methodPath);
            throw new MQProducerException("ark-spring-boot-starter >> \u68c0\u6d4b\u5230\u751f\u4ea7\u8005\u65b9\u6cd5'" + methodPath + "'\u7684transactionLocalTimeOut\u5c5e\u6027\u672a\u8bbe\u7f6e\u6216\u914d\u7f6e\u9879\u672a\u914d\u7f6e");
        }
        TransactionMessageManage transactionMessageManage = this.getTransactionMessageManage(ctx);
        if (transactionMessageManage == null) {
            log.error("ark-spring-boot-starter >> \u56e0\u4e8b\u52a1\u6d88\u606f\u7ba1\u7406\u5668\u672a\u914d\u7f6e,'{}'\u4e0a\u7684@TransactionMessage\u6ce8\u89e3\u914d\u7f6e\u65e0\u6548,", (java.lang.Object)methodPath);
            throw new MQProducerException("ark-spring-boot-starter >> '" + methodPath + "'\u4e0a\u7684@TransactionMessage\u6ce8\u89e3\u914d\u7f6e\u65e0\u6cd5\u751f\u6548,\u4e8b\u52a1\u7ba1\u7406\u5668\u672a\u914d\u7f6e");
        }
    }

    protected RocketSendMessageMethodModel resolveRocketMessage(ApplicationContext ctx, RocketProducer producerAnnotation, Method m) {
        RocketMessage rocketMessage = m.getAnnotation(RocketMessage.class);
        if (rocketMessage == null) {
            return null;
        }
        ProducerParamTypeEnum paramTypeEnum = this.getAndCheckMethodParam(m, rocketMessage.sendType());
        ProducerReturnTypeEnum returnTypeEnum = this.getAndCheckMethodReturn(m, rocketMessage.sendType());
        TransactionMessageMethodModel transactionMessageMethodModel = this.resolveTransactionMessage(ctx, m);
        ProducerTypeEnum producerTypeEnum = transactionMessageMethodModel == null ? ProducerTypeEnum.DEFAULT_NOMAL_PRODUCER : ProducerTypeEnum.TRANSACTION_MESSAGE_PRODUCER;
        RocketSendMessageMethodModel messageMethodModel = RocketSendMessageMethodModel.builder().groupId(ConfigUtil.getProperty(producerAnnotation.groupId(), ctx)).topic(ConfigUtil.getProperty(rocketMessage.topic(), ctx)).tag(ConfigUtil.getProperty(rocketMessage.tag(), ctx)).msgKeyPrefix(ConfigUtil.getProperty(rocketMessage.msgKeyPrefix(), ctx)).delayTime(ConfigUtil.getProperty(rocketMessage.delayTime(), ctx)).sendErrorThrowEx(rocketMessage.sendErrorThrowEx()).sendTypeEnum(rocketMessage.sendType()).interfaceMethod(m).paramTypeEnum(paramTypeEnum).returnTypeEnum(returnTypeEnum).producerTypeEnum(producerTypeEnum).transactionMessageMethodModel(transactionMessageMethodModel).build();
        return messageMethodModel;
    }

    private TransactionMessageMethodModel resolveTransactionMessage(ApplicationContext ctx, Method m) {
        TransactionMessage transactionMessage = m.getAnnotation(TransactionMessage.class);
        if (transactionMessage == null) {
            return null;
        }
        TransactionMessageMethodModel transactionMessageMethodModel = TransactionMessageMethodModel.builder().transactionLocalTimeOut(ConfigUtil.getProperty(transactionMessage.localTimeOut(), ctx)).build();
        return transactionMessageMethodModel;
    }

    protected RocketSendMessageMethodModel resolveRocketMessageAsync(ApplicationContext ctx, RocketProducer producerAnnotation, Method m) {
        RocketMessageAsync rocketMessage = m.getAnnotation(RocketMessageAsync.class);
        if (rocketMessage == null) {
            return null;
        }
        ProducerParamTypeEnum paramTypeEnum = this.getAndCheckMethodParam(m, ProducerSendTypeEnum.ASYNC);
        ProducerReturnTypeEnum returnTypeEnum = this.getAndCheckMethodReturn(m, ProducerSendTypeEnum.ASYNC);
        TransactionMessageMethodModel transactionMessageMethodModel = this.resolveTransactionMessage(ctx, m);
        ProducerTypeEnum producerTypeEnum = transactionMessageMethodModel == null ? ProducerTypeEnum.DEFAULT_NOMAL_PRODUCER : ProducerTypeEnum.TRANSACTION_MESSAGE_PRODUCER;
        RocketSendMessageMethodModel messageMethodModel = RocketSendMessageMethodModel.builder().groupId(ConfigUtil.getProperty(producerAnnotation.groupId(), ctx)).topic(ConfigUtil.getProperty(rocketMessage.topic(), ctx)).tag(ConfigUtil.getProperty(rocketMessage.tag(), ctx)).delayTime(ConfigUtil.getProperty(rocketMessage.delayTime(), ctx)).sendTypeEnum(ProducerSendTypeEnum.ASYNC).msgKeyPrefix(ConfigUtil.getProperty(rocketMessage.msgKeyPrefix(), ctx)).interfaceMethod(m).paramTypeEnum(paramTypeEnum).returnTypeEnum(returnTypeEnum).producerTypeEnum(producerTypeEnum).transactionMessageMethodModel(transactionMessageMethodModel).build();
        return messageMethodModel;
    }

    protected ProducerParamTypeEnum getAndCheckMethodParam(Method m, ProducerSendTypeEnum sendTypeEnum) {
        Class[] paramTypes = m.getParameterTypes();
        ProducerParamTypeEnum producerParamTypeEnum = ProducerParamTypeEnum.getByParamsClass(paramTypes);
        if (producerParamTypeEnum == null) {
            log.error("ark-spring-boot-starter >> {}\u65b9\u6cd5\u7684\u53c2\u6570\u5217\u8868\u4e0d\u5408\u6cd5,\u65e0\u6cd5\u81ea\u52a8\u5316\u914d\u7f6emq\u751f\u4ea7\u8005\u5b9e\u4f8b\uff01", (java.lang.Object)m);
            throw new MQProducerException("ark-spring-boot-starter >> \u68c0\u6d4b\u5230" + m + "\u65b9\u6cd5\u7684\u53c2\u6570\u5217\u8868\u4e0d\u5408\u6cd5");
        }
        ProducerSendTypeEnum[] paramAllowSendType = producerParamTypeEnum.getSendTypeEnum();
        Optional<ProducerSendTypeEnum> paramSendTypeOptional = Arrays.stream(paramAllowSendType).filter(e -> e.equals((java.lang.Object)sendTypeEnum)).findFirst();
        if (!paramSendTypeOptional.isPresent()) {
            log.error("ark-spring-boot-starter >> {}\u65b9\u6cd5\u7684\u53c2\u6570\u5217\u8868\u4e0d\u5408\u6cd5\uff01", (java.lang.Object)m);
            throw new MQProducerException("ark-spring-boot-starter >> \u68c0\u6d4b\u5230" + m + "\u65b9\u6cd5\u7684\u53c2\u6570\u5217\u8868\u4e0d\u5408\u6cd5");
        }
        return producerParamTypeEnum;
    }

    protected ProducerReturnTypeEnum getAndCheckMethodReturn(Method m, ProducerSendTypeEnum sendTypeEnum) {
        ProducerReturnTypeEnum returnTypeEnum = ProducerReturnTypeEnum.getByValue(m.getReturnType().getName());
        if (returnTypeEnum == null) {
            log.error("ark-spring-boot-starter >> {}\u65b9\u6cd5\u7684\u8fd4\u56de\u503c\u4e0d\u5408\u6cd5\uff01\u76ee\u524d\u8fd4\u56de\u503c\u4ec5\u652f\u6301void, com.fshows.ark.spring.boot.starter.core.mq.base.FsSendResult\u7c7b\u578b", (java.lang.Object)m);
            throw new MQProducerException("ark-spring-boot-starter >> \u68c0\u6d4b\u5230" + m + "\u65b9\u6cd5\u7684\u8fd4\u56de\u503c\u4e0d\u5408\u6cd5");
        }
        ProducerSendTypeEnum[] returnAllowSendType = returnTypeEnum.getSendTypeEnum();
        Optional<ProducerSendTypeEnum> returnSendTypeOptional = Arrays.stream(returnAllowSendType).filter(e -> e.equals((java.lang.Object)sendTypeEnum)).findFirst();
        if (!returnSendTypeOptional.isPresent()) {
            log.error("ark-spring-boot-starter >> {}\u65b9\u6cd5\u7684\u8fd4\u56de\u503c\u4e0d\u5408\u6cd5\uff01\u5f53\u524d\u53d1\u9001\u65b9\u5f0f\u4e0d\u652f\u6301'{}'\u7c7b\u578b", (java.lang.Object)m, (java.lang.Object)m.getReturnType().getName());
            throw new MQProducerException("ark-spring-boot-starter >> \u68c0\u6d4b\u5230" + m + "\u65b9\u6cd5\u7684\u8fd4\u56de\u503c\u4e0d\u5408\u6cd5");
        }
        return returnTypeEnum;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

