/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package com.fshows.ark.spring.boot.starter.extend.mq.interceptor;

import com.fshows.ark.spring.boot.starter.constant.MQConstant;
import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsMessageSendContext;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsProducerInterceptor;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendResult;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.MDC;
import org.springframework.core.annotation.Order;

import java.util.HashMap;
import java.util.Map;

/**
 * 生产者traceId拦截器
 *
 * @author liluqing
 * @version TradeIdConsumeInterceptor.java, v 0.1 2022-09-08 18:40
 */
@Slf4j
@Order(1)
public class TraceIdProducerInterceptor implements FsProducerInterceptor {

    @Override
    public void beforeSend(FsMessageSendContext context) {
        FsMessage message = context.getFsMessage();
        Map<Object, Object> extendMap = message.getExtendParam() == null ?
                new HashMap<>() : message.getExtendParam();
        // 将traceid保存到mq消息额外参数中
        extendMap.put(MQConstant.TRACE_ID, MDC.get(MQConstant.TRACE_ID));
        message.setExtendParam(extendMap);
    }

    @Override
    public void afterSend(FsMessageSendContext context, FsSendResult result) {

    }
}
