/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.mq.rocketmq.consumer;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage;
import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessageConvert;
import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.FsConsumerModel;
import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.FsMessageListener;

/**
 * 阿里云消息listener适配器
 *
 * @author liluqing
 * @version AliyunMessageListenerImpl.java, v 0.1 2021-09-27 18:03
 */
public class AliyunMessageListenerAdapter implements MessageListener {

    /**
     * 消息监听
     */
    private FsMessageListener messageListener;

    /**
     * 消费者相关原信息
     */
    private FsConsumerModel fsConsumerModel;

    public AliyunMessageListenerAdapter(FsMessageListener messageListener, FsConsumerModel fsConsumerModel) {
        this.messageListener = messageListener;
        this.fsConsumerModel = fsConsumerModel;
    }

    @Override
    public Action consume(Message message, ConsumeContext context) {
        FsMessage fsMessage = FsMessageConvert.convertFsMessage(message, fsConsumerModel.getConsumerProperties().getCharsetName());
        boolean bo = messageListener.consume(fsMessage);
        return bo ? Action.CommitMessage : Action.ReconsumeLater;
    }
}