/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.mq.base.producer;

/**
 * 生产者动态更新
 *
 * @author liluqing
 * @version ProducerProxyUpdateHandler.java, v 0.1 2025-06-17 16:14
 */
public interface IProducerConfigUpdateHandler {

    /**
     * 重新启动生产者示例，并使用最新配置。
     */
    void restart();

    /**
     * 获取生产者配置元信息
     */
    FsProducerModel getFsProducerModel();

    /**
     * producer bean信息
     * @return
     */
    IFshowsProducer getProducer();

    /**
     * 当前持有事务管理器
     * @return
     */
    TransactionMessageManage getTransactionMessageManage();
}