/**
 * fshows.com
 * Copyright (C) 2013-2019 All Rights Reserved.
 */
package com.fshows.ark.spring.boot.starter.core.mq.base.producer;

import lombok.Data;

/**
 * 消息发送结果
 *
 * @author Liluqing
 * @version FsSendResult.java, v 0.1 2019-07-08 14:30
 */
@Data
public class FsSendResult {

    /**
     * 消息发送状态,是否发送成功
     */
    private boolean success = false;

    /**
     * 失败异常
     */
    private Exception ex;

    /**
     * 已发送消息的ID
     */
    private String messageId;

    /**
     * 已发送消息的主题
     */
    private String topic;

    public FsSendResult() {}

    public FsSendResult(boolean success, String messageId) {
        this.success = success;
        this.messageId = messageId;
    }

    public FsSendResult(Exception ex) {
        this.ex = ex;
    }
}