/**
 * fshows.com
 * Copyright (C) 2013-2019 All Rights Reserved.
 */
package com.fshows.ark.spring.boot.starter.core.mq.base.consumer;

import com.fshows.ark.spring.boot.starter.enums.ConsumerParamTypeEnum;
import com.fshows.ark.spring.boot.starter.enums.ConsumerReturnTypeEnum;
import lombok.Data;

import java.lang.reflect.Method;

/**
 *
 * @author Liluqing
 * @version RocketConsumerModel.java, v 0.1 2019-08-15 10:22
 */
@Data
public class FsConsumerModel {

    /**
     * 消费者原始bean的名称
     */
    private String beanName;

    /**
     * 消费者原始bean
     */
    private Object target;

    /**
     * 消费方法
     */
    private Method listenerMethod;

    /**
     * 消费方法入参类型
     */
    private ConsumerParamTypeEnum paramTypeEnum;

    /**
     * 消费方法返回值类型
     */
    private ConsumerReturnTypeEnum returnTypeEnum;

    /**
     * 消费者相关属性
     */
    private FsConsumerModelProperties consumerProperties;

    /**
     * 消费者相关属性的配置key
     */
    private FsConsumerConfigKey consumerConfigKey;
}