/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.mq.base;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.OnExceptionContext;
import com.aliyun.openservices.ons.api.SendResult;
import com.fshows.ark.spring.boot.starter.constant.MQConstant;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendExceptionHolder;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendResult;
import com.fshows.ark.spring.boot.starter.exception.MQMessageConvertException;
import com.fshows.ark.spring.boot.starter.util.StrUtil;
import lombok.extern.slf4j.Slf4j;

import java.io.UnsupportedEncodingException;
import java.util.Map;

/**
 *
 * @author liluqing
 * @version FsMessageConvert.java, v 0.1 2021-08-20 16:22
 */
@Slf4j
public class FsMessageConvert {

    /**
     * 阿里云message 转 FsMessage
     *
     * @param message
     * @return
     */
    public static FsMessage convertFsMessage(Message message, String charsetName) {
        FsMessage fsMessage = new FsMessage();
        fsMessage.setTag(message.getTag());
        fsMessage.setTopic(message.getTopic());
        fsMessage.setKey(message.getKey());
        try {
            fsMessage.setContent(new String(message.getBody(), charsetName));
        } catch (UnsupportedEncodingException e) {
            throw new MQMessageConvertException("ark-spring-boot-starter >> 阿里云Message 转 FsMessage失败, body序列化为string失败!");
        }
        fsMessage.setExtendParam(message.getUserProperties());
        return fsMessage;
    }

    /**
     * 阿里云message 转 FsMessage
     *
     * @param message
     * @return
     */
    public static FsMessage convertFsMessage(Message message) {
        FsMessage fsMessage = new FsMessage();
        fsMessage.setTag(message.getTag());
        fsMessage.setTopic(message.getTopic());
        fsMessage.setKey(message.getKey());
        fsMessage.setContentBody(message.getBody());
        fsMessage.setExtendParam(message.getUserProperties());
        return fsMessage;
    }

    /**
     * FsMessage 转 阿里云message
     *
     * @param fsMessage
     * @return
     */
    public static Message convertMessage(FsMessage fsMessage, String charsetName) {
        if (fsMessage == null) {
            return null;
        }
        Message message;
        if (fsMessage.getExtendParam() != null && fsMessage.getExtendParam().containsKey(MQConstant.ALIYUN_ORIGINAL_MESSAGE)) {
            message = (Message) fsMessage.getExtendParam().get(MQConstant.ALIYUN_ORIGINAL_MESSAGE);
        } else {
            message = new Message();
        }
        message.setTag(fsMessage.getTag());
        message.setTopic(fsMessage.getTopic());
        message.setKey(fsMessage.getKey());
        try {
            if (fsMessage.getContentBody() != null) {
                message.setBody(fsMessage.getContentBody());
            } else if (fsMessage.getContent() != null) {
                message.setBody(fsMessage.getContent().getBytes(charsetName));
            }
        } catch (UnsupportedEncodingException e) {
            throw new MQMessageConvertException("ark-spring-boot-starter >> FsMessage 转 阿里云Message , contentString反序列化为string失败!");
        }
        if (fsMessage.getExtendParam() != null) {
            for (Map.Entry<Object, Object> entry : fsMessage.getExtendParam().entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) {
                    continue;
                }
                message.putUserProperties(StrUtil.ifNullDefaultEmpty(entry.getKey()), StrUtil.ifNullDefaultEmpty(entry.getValue()));
            }
        }
        if (fsMessage.getSendTime() > 0) {
            message.setStartDeliverTime(fsMessage.getSendTime());
        }
        return message;
    }

    /**
     * SendResult 转 FsSendResult
     *
     * @param sendResult
     * @return
     */
    public static FsSendResult convertFsSendResult(SendResult sendResult) {
        FsSendResult fsSendResult = new FsSendResult();
        fsSendResult.setSuccess(true);
        fsSendResult.setTopic(sendResult.getTopic());
        fsSendResult.setMessageId(sendResult.getMessageId());
        return fsSendResult;
    }

    /**
     * 构建一个发送成功的响应结果
     *
     * @return
     */
    public static FsSendResult buildSendResult(FsMessage fsMessage, boolean success) {
        FsSendResult fsSendResult = new FsSendResult();
        fsSendResult.setSuccess(success);
        fsSendResult.setTopic(fsMessage.getTopic());
        return fsSendResult;
    }

    /**
     * SendResult 转 FsSendResult
     *
     * @param onExceptionContext
     * @return
     */
    public static FsSendExceptionHolder convertFsSendExceptionContext(OnExceptionContext onExceptionContext) {
        FsSendExceptionHolder context = new FsSendExceptionHolder();
        context.setTopic(onExceptionContext.getTopic());
        context.setMessageId(onExceptionContext.getMessageId());
        context.setException(onExceptionContext.getException());
        return context;
    }


    /**
     * SendResult 转 FsSendResult
     *
     * @param onExceptionContext
     * @return
     */
    public static FsSendResult convertFsSendResult(OnExceptionContext onExceptionContext) {
        FsSendResult fsSendResult = new FsSendResult();
        fsSendResult.setSuccess(false);
        fsSendResult.setTopic(onExceptionContext.getTopic());
        fsSendResult.setMessageId(onExceptionContext.getMessageId());
        fsSendResult.setEx(onExceptionContext.getException());
        return fsSendResult;
    }


}