/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.annotation.mq;

import com.fshows.ark.spring.boot.starter.constant.CommonConfigConstant;
import com.fshows.ark.spring.boot.starter.constant.MqConfigConstant;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 *
 * @author liluqing
 * @version RocketProducer.java, v 0.1 2021-08-12 19:49
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE})
@Inherited
public @interface RocketProducer {

    /**
     * 生产者组
     *
     * @return
     */
    String groupId() default MqConfigConstant.PRODUCER_DEFAULT_GROUP;

    /**
     * 生产者消费发送默认超时时间（单位：毫秒）
     *
     * @return
     */
    String sendMsgTimeoutMillis() default MqConfigConstant.PRODUCER_SEND_MSG_TIMEOUT;

    /**
     * mq nameSever地址
     */
    String namesrvAddr() default MqConfigConstant.NAME_SERVER_ADDR;

    /**
     * 授权key
     */
    String accessKey() default CommonConfigConstant.ALIYUN_ACCESS_KEY;

    /**
     * 密钥
     */
    String secretKey() default CommonConfigConstant.ALIYUN_SECRET_KEY;

    /**
     * 消息内容的默认字符集编码
     */
    String msgContentCharset() default MqConfigConstant.PRODUCER_CONTENT_CHARSET;

}