/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.extend.mq.configlistener;

import cn.hutool.core.collection.CollectionUtil;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsProducerConfigUpdateModel;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.IProducerConfigUpdateHandler;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.IProducerProxyFactory;
import com.fshows.ark.spring.boot.starter.exception.MQConsumerException;
import com.fshows.ark.spring.boot.starter.extend.mq.configlistener.ConfigChangeModel;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProducerConfigChangeListener {
    private static final Logger log = LoggerFactory.getLogger(ProducerConfigChangeListener.class);
    private IProducerProxyFactory producerProxyFactory;

    public ProducerConfigChangeListener(IProducerProxyFactory producerProxyFactory) {
        this.producerProxyFactory = producerProxyFactory;
    }

    public void reloadConfig(List<ConfigChangeModel> configChangeModels) {
        if (configChangeModels == null || configChangeModels.isEmpty()) {
            return;
        }
        log.info("ark-spring-boot-starter >> \u5f00\u59cb\u5904\u7406\u751f\u4ea7\u8005\u914d\u7f6e\u53d8\u66f4\uff0c\u53d8\u66f4\u9879\u6570\u91cf: {}", (Object)configChangeModels.size());
        Set<IProducerConfigUpdateHandler> changedProxyHandlers = this.updateProxyConfig(configChangeModels);
        if (CollectionUtil.isEmpty(changedProxyHandlers)) {
            log.debug("ark-spring-boot-starter >> \u672c\u6b21\u914d\u7f6e\u53d8\u66f4\u4e0d\u6d89\u53ca\u963f\u91cc\u4e91AK/SK\uff0c\u8df3\u8fc7\u751f\u4ea7\u8005\u66f4\u65b0");
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                int delaySeconds = ThreadLocalRandom.current().nextInt(1, 6);
                log.info("ark-spring-boot-starter >> \u5c06\u5728{}\u79d2\u540e\u5f00\u59cb\u66f4\u65b0\u751f\u4ea7\u8005\u5b9e\u4f8b", (Object)delaySeconds);
                TimeUnit.SECONDS.sleep(delaySeconds);
                this.updateProducersForAkSkChange(changedProxyHandlers);
            }
            catch (Exception e) {
                log.error("ark-spring-boot-starter >> \u66f4\u65b0\u751f\u4ea7\u8005\u5b9e\u4f8b\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
        });
    }

    private Set<IProducerConfigUpdateHandler> updateProxyConfig(List<ConfigChangeModel> configChangeModels) {
        ConcurrentHashMap.KeySetView allAffectedHandlers = ConcurrentHashMap.newKeySet();
        Map<String, Set<FsProducerConfigUpdateModel>> producerConfigUpdateModelMap = this.producerProxyFactory.getFsProducerConfigUpdateModelMap();
        for (ConfigChangeModel config : configChangeModels) {
            Set<FsProducerConfigUpdateModel> updateModels = producerConfigUpdateModelMap.get(config.getKey());
            if (CollectionUtil.isEmpty(updateModels)) continue;
            for (FsProducerConfigUpdateModel model : updateModels) {
                boolean success;
                Field f = model.getField();
                String oldValue = this.getFieldValueStr(model.getTarget(), f);
                if (oldValue != null && oldValue.equals(config.getNewValue()) || !(success = this.setFieldValueStr(config.getNewValue(), model.getTarget(), f))) continue;
                allAffectedHandlers.add(model.getConfigUpdateHandler());
            }
        }
        return allAffectedHandlers;
    }

    private void updateProducersForAkSkChange(Set<IProducerConfigUpdateHandler> producerConfigUpdateHandlerSet) {
        log.info("ark-spring-boot-starter >> \u5f00\u59cb\u66f4\u65b0\u53d7AK/SK\u914d\u7f6e\u53d8\u66f4\u5f71\u54cd\u7684\u751f\u4ea7\u8005\u5b9e\u4f8b");
        if (producerConfigUpdateHandlerSet.isEmpty()) {
            log.info("ark-spring-boot-starter >> \u672a\u627e\u5230\u53d7\u5f71\u54cd\u7684\u751f\u4ea7\u8005\u4ee3\u7406Handler");
            return;
        }
        log.info("ark-spring-boot-starter >> \u627e\u5230{}\u4e2a\u53d7\u5f71\u54cd\u7684\u751f\u4ea7\u8005\u4ee3\u7406Handler\uff0c\u5f00\u59cb\u66f4\u65b0", (Object)producerConfigUpdateHandlerSet.size());
        int successCount = 0;
        int failureCount = 0;
        for (IProducerConfigUpdateHandler handler : producerConfigUpdateHandlerSet) {
            try {
                handler.restart();
                ++successCount;
                log.info("ark-spring-boot-starter >> \u6210\u529f\u66f4\u65b0\u751f\u4ea7\u8005\u5b9e\u4f8b");
            }
            catch (Exception e) {
                ++failureCount;
                log.error("ark-spring-boot-starter >> \u66f4\u65b0\u751f\u4ea7\u8005\u5b9e\u4f8b\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
        }
        log.info("ark-spring-boot-starter >> \u751f\u4ea7\u8005\u5b9e\u4f8b\u66f4\u65b0\u5b8c\u6210\uff0c\u6210\u529f: {}, \u5931\u8d25: {}", (Object)successCount, (Object)failureCount);
    }

    public boolean setFieldValueStr(String value, Object target, Field field) {
        try {
            field.setAccessible(true);
            field.set(target, value);
            return true;
        }
        catch (IllegalAccessException e) {
            log.error("ark-spring-boot-starter >> mq\u6d88\u8d39\u8005\u914d\u7f6e\u53d8\u66f4\u76d1\u542c\u5668\u5f02\u5e38 >> \u52a8\u6001\u52a0\u8f7d\u53d8\u66f4\u914d\u7f6e\u5f02\u5e38 >> value={}", (Object)value);
            return false;
        }
    }

    public String getFieldValueStr(Object target, Field field) {
        try {
            field.setAccessible(true);
            Object value = field.get(target);
            return value == null ? null : value.toString();
        }
        catch (IllegalAccessException e) {
            log.error("ark-spring-boot-starter >> mq\u6d88\u8d39\u8005\u914d\u7f6e\u53d8\u66f4\u76d1\u542c\u5668\u52a0\u8f7d\u5f02\u5e38!", (Throwable)e);
            throw new MQConsumerException("ark-spring-boot-starter >> mq\u6d88\u8d39\u8005\u914d\u7f6e\u53d8\u66f4\u76d1\u542c\u5668\u52a0\u8f7d\u5f02\u5e38\uff01");
        }
    }
}

