/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.core.configservice.apollo;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.fshows.ark.spring.boot.starter.core.configservice.FsConfigChangeListener;
import com.fshows.ark.spring.boot.starter.util.ConfigUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.util.StringUtils;

@ConditionalOnClass(value={ConfigService.class})
public class ConfigServicesListener
implements ApplicationRunner {
    Map<String, List<FsConfigChangeListener>> listenerMap = new ConcurrentHashMap<String, List<FsConfigChangeListener>>(10);

    public void addChangeListener(String keys, FsConfigChangeListener fsConfigChangeListener) {
        String[] keyArr = StringUtils.split((String)keys, (String)",");
        if (keyArr == null) {
            return;
        }
        for (String k : keyArr) {
            String realkey = ConfigUtil.getDynamicKey(k);
            List<FsConfigChangeListener> configChangeListenerList = this.listenerMap.get(realkey);
            if (configChangeListenerList == null) {
                configChangeListenerList = new CopyOnWriteArrayList<FsConfigChangeListener>();
                this.listenerMap.put(realkey, configChangeListenerList);
            }
            configChangeListenerList.add(fsConfigChangeListener);
        }
    }

    public void run(ApplicationArguments args) throws Exception {
        Config config = ConfigService.getAppConfig();
        config.addChangeListener(changeEvent -> {
            for (String key : changeEvent.changedKeys()) {
                ConfigChange change = changeEvent.getChange(key);
                List<FsConfigChangeListener> listenerList = this.listenerMap.get(change.getPropertyName());
                if (listenerList == null || listenerList.size() == 0) continue;
                for (FsConfigChangeListener changeListener : listenerList) {
                    try {
                        changeListener.onchange(change);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }
}

