/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.util;

import java.nio.charset.StandardCharsets;
import java.util.Base64;

/**
 *
 * @author liluqing
 * @version FsBase64Util.java, v 0.1 2024-06-25 15:29
 */
public class FsBase64Util {

    /**
     * base64编码
     *
     * @param input
     * @return
     */
    public static String encode(String input) {
        return Base64.getEncoder().encodeToString(input.getBytes(StandardCharsets.UTF_8));
    }

    /**
     * base64编码
     *
     * @param bytes
     * @return
     */
    public static String encode(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }


    /**
     * base64解码
     *
     * @param input
     * @return
     */
    public static String decode(String input) {
        byte[] decodedBytes = Base64.getDecoder().decode(input.getBytes(StandardCharsets.UTF_8));
        return new String(decodedBytes, StandardCharsets.UTF_8);
    }

    /**
     * base64解码
     *
     * @param input
     * @return
     */
    public static byte[] decodeBytes(String input) {
        return Base64.getDecoder().decode(input.getBytes(StandardCharsets.UTF_8));
    }



    public static void main(String[] args) {
        String originalString = "Hello, World!";
        String encodedString = encode(originalString);
        System.out.println("Encoded: " + encodedString);

        String decodedString = decode(encodedString);
        System.out.println("Decoded: " + decodedString);
    }
}