/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.sensitive.model;

import lombok.Data;

/**
 * 敏感字段加密配置
 *
 * 配置示例：[{"keyId":"1","algorithmType":"SM4","seed":"123456","isDefault":true}]
 * @author liluqing
 * @version SensitiveConfigModel.java, v 0.1 2024-05-29 14:11
 */
@Data
public class SensitiveConfigItem {

    /**
     * 密钥名称
     */
    public String secretName;

    /**
     * 密钥ID
     */
    private String keyId;

    /**
     * 算法类型，例如: SM4
     */
    private String algorithmType;

    /**
     * 密钥种子
     */
    private String seed;
}