/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.sensitive.encrypt.strategy;

import cn.hutool.crypto.symmetric.SymmetricAlgorithm;
import cn.hutool.crypto.symmetric.SymmetricCrypto;
import com.fshows.ark.spring.boot.starter.core.sensitive.encrypt.IFieldEncryptStrategy;
import com.fshows.ark.spring.boot.starter.core.sensitive.enums.AlgorithmTypeEnum;
import com.fshows.ark.spring.boot.starter.core.sensitive.model.SecretKeyModel;
import com.fshows.ark.spring.boot.starter.exception.DbSensitiveException;
import com.fshows.ark.spring.boot.starter.util.LogUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * sm4 加密算法
 *
 * @author liluqing
 * @version RsaFieldEncryptStrategy.java, v 0.1 2024-05-27 17:15
 */
@Component
@Slf4j
public class AesFieldEncryptStrategy implements IFieldEncryptStrategy {

    @Override
    public byte[] encrypt(byte[] plaintext, SecretKeyModel model) {
        try {
            //构建
            SymmetricCrypto aes = new SymmetricCrypto(SymmetricAlgorithm.AES, model.getPrivateKey());
            //加密
            return aes.encrypt(plaintext);
        } catch (Exception e) {
            LogUtil.error(log, "ark-spring-boot-starter >>  数据库敏感字段加密 >> 数据加密异常 ", e);
            throw new DbSensitiveException("ark-spring-boot-starter >> 数据库敏感字段加密 >> 数据加密异常");
        }
    }

    @Override
    public byte[] decrypt(byte[] ciphertext, SecretKeyModel model) {
        try {
            //构建
            SymmetricCrypto aes = new SymmetricCrypto(SymmetricAlgorithm.AES, model.getPrivateKey());
            //解密
            return aes.decrypt(ciphertext);
        } catch (Exception e) {
            LogUtil.error(log, "ark-spring-boot-starter >>  数据库敏感字段加密 >> 数据解密异常 ", e);
            throw new DbSensitiveException("ark-spring-boot-starter >> 数据库敏感字段加密 >> 数据解密异常");
        }
    }

    @Override
    public AlgorithmTypeEnum getAlgorithmTypeEnum() {
        return AlgorithmTypeEnum.AES;
    }
}