/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.invoke;

import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsProducerInvoke;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendErrorCallback;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendSuccessCallback;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.RocketSendMessageMethodModel;
import com.fshows.ark.spring.boot.starter.enums.ProducerParamTypeEnum;

/**
 * fsMesage参数Invoke
 *
 * @author liluqing
 * @version FsMessageInvoke.java, v 0.1 2021-08-29 22:01
 */
public class FsMessageInvoke implements FsProducerInvoke {

    @Override
    public FsMessage buildFsMessage(RocketSendMessageMethodModel sendMessageMethodModel, Object[] args) {
        FsMessage fsMessage = (FsMessage) args[0];
        if (fsMessage == null) {
            return null;
        }
        fsMessage.setTopic(sendMessageMethodModel.getTopic());
        fsMessage.setTag(sendMessageMethodModel.getTag());
        fsMessage.setSendTime(sendMessageMethodModel.getSendTime());
        return fsMessage;
    }

    @Override
    public FsSendSuccessCallback buildFsSendSuccessCallback(RocketSendMessageMethodModel sendMessageMethodModel, Object[] args) {
        if (ProducerParamTypeEnum.FS_MESSAGE_ASYNC_SUCCESS.equals(sendMessageMethodModel.getParamTypeEnum())) {
            return (FsSendSuccessCallback) args[1];
        }
        if (ProducerParamTypeEnum.FS_MESSAGE_ASYNC.equals(sendMessageMethodModel.getParamTypeEnum())) {
            return (FsSendSuccessCallback) args[1];
        }
        return null;
    }

    @Override
    public FsSendErrorCallback buildFsSendErrorCallback(RocketSendMessageMethodModel sendMessageMethodModel, Object[] args) {
        if (ProducerParamTypeEnum.FS_MESSAGE_ASYNC.equals(sendMessageMethodModel.getParamTypeEnum())) {
            return (FsSendErrorCallback) args[2];
        }
        if (ProducerParamTypeEnum.FS_MESSAGE_ASYNC_ERROR.equals(sendMessageMethodModel.getParamTypeEnum())) {
            return (FsSendErrorCallback) args[1];
        }
        return null;
    }
}