/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.mq.rocketmq.interceptor;

import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsMessageSendContext;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsProducerInterceptor;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendResult;

import java.util.List;

/**
 * 拦截器执行者
 *
 * @author liluqing
 * @version DefaultProducerInterceptorActuator.java, v 0.1 2021-10-26 22:06
 */
public class DefaultProducerInterceptorActuator implements ProducerInterceptorActuator {

    /**
     * 拦截器列表
     */
    private List<FsProducerInterceptor> InterceptorList;

    public DefaultProducerInterceptorActuator(List<FsProducerInterceptor> InterceptorList) {
        this.InterceptorList = InterceptorList;
    }

    @Override
    public void doBeforeSend(FsMessageSendContext context) {
        for (FsProducerInterceptor fsProducerInterceptor: InterceptorList) {
            fsProducerInterceptor.beforeSend(context);
        }
    }

    @Override
    public void doAfterSend(FsMessageSendContext context, FsSendResult result) {
        for (FsProducerInterceptor fsProducerInterceptor: InterceptorList) {
            fsProducerInterceptor.afterSend(context, result);
        }
    }
}