/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.mq.base.producer;

import java.util.Map;
import java.util.Set;

/**
 * 生产者代理类工厂
 *
 * @author liluqing
 * @version IProducerProxyFactory.java, v 0.1 2021-08-30 19:26
 */
public interface IProducerProxyFactory {

    /**
     * 构建生产者代理类
     *
     * @param producerInterface 生产者接口类
     * @param <T>
     * @return
     */
    <T> T bulidRocketProducerProxy(Class<T> producerInterface);

    /**
     * 创建生产者实例bean
     *
     * @param fsProducerModel
     * @param transactionMessageManage
     * @return
     */
    IFshowsProducer getFshowsProducer(FsProducerModel fsProducerModel,
                                      TransactionMessageManage transactionMessageManage);

    /**
     * 获取动态key和代理Handler的映射关系 map
     *
     * @return 受影响的代理Handler集合
     */
    Map<String, Set<FsProducerConfigUpdateModel>> getFsProducerConfigUpdateModelMap();
}