/**
 * fshows.com
 * Copyright (C) 2013-2019 All Rights Reserved.
 */
package com.fshows.ark.spring.boot.starter.core.mq.base.consumer;

import lombok.Data;

/**
 *
 * @author Liluqing
 * @version RocketConsumerProperties.java, v 0.1 2019-08-15 10:28
 */
@Data
public class FsConsumerModelProperties {
    /**
     * 消费者GID
     */
    private String groupId;

    /**
     * 消费者订阅的topic
     */
    private String topic;

    /**
     * 消费者订阅的tags
     */
    private String tags;

    /**
     * 最大消费重试次数
     */
    private String maxReconsumeTimes;

    /**
     * 消费者消费线程数
     */
    private String consumeThreadNums;

    /**
     * 消费超时时间（单位分钟）
     */
    private String consumeTimeout;

    /**
     * 授权key
     */
    private String accessKey;

    /**
     * 密钥
     */
    private String secretKey;

    /**
     * mq nameSever地址
     */
    private String namesrvAddr;

    /**
     * 消息内容字符集编码
     */
    private String charsetName;
}