/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.util;

import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;

public class Sm4Util {
    public static void main(String[] args) throws Exception {
        KeyGenerator keyGen = KeyGenerator.getInstance("SM4", "BC");
        keyGen.init(128);
        SecretKey secretKey = keyGen.generateKey();
        byte[] key = secretKey.getEncoded();
        String plaintext = "Hello, SM4!";
        byte[] plaintextBytes = plaintext.getBytes();
        byte[] ciphertextBytes = Sm4Util.encrypt(plaintextBytes, key);
        System.out.println("Ciphertext (Hex): " + Hex.toHexString((byte[])ciphertextBytes));
        byte[] decryptedBytes = Sm4Util.decrypt(ciphertextBytes, key);
        String decryptedText = new String(decryptedBytes);
        System.out.println("Decrypted Text: " + decryptedText);
    }

    public static byte[] encrypt(byte[] plaintext, byte[] key) throws Exception {
        Cipher cipher = Cipher.getInstance("SM4/ECB/PKCS5Padding", "BC");
        SecretKeySpec keySpec = new SecretKeySpec(key, "SM4");
        cipher.init(1, keySpec);
        return cipher.doFinal(plaintext);
    }

    public static byte[] decrypt(byte[] ciphertext, byte[] key) throws Exception {
        Cipher cipher = Cipher.getInstance("SM4/ECB/PKCS5Padding", "BC");
        SecretKeySpec keySpec = new SecretKeySpec(key, "SM4");
        cipher.init(2, keySpec);
        return cipher.doFinal(ciphertext);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

