/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.extend.mq.configlistener;

import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.FsConsumerConfigKey;
import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.FsConsumerModel;
import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.FsConsumerModelProperties;
import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.IFshowsConsumer;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.consumer.AbstractConsumerContainer;
import com.fshows.ark.spring.boot.starter.exception.MQConsumerException;
import com.fshows.ark.spring.boot.starter.extend.mq.configlistener.ConfigChangeModel;
import com.fshows.ark.spring.boot.starter.extend.mq.configlistener.MQPropertyModel;
import com.fshows.ark.spring.boot.starter.util.ConfigUtil;
import com.fshows.ark.spring.boot.starter.util.StrUtil;
import com.fshows.ark.spring.boot.starter.util.ThreadUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class ConsumeConfigChangeListener {
    private static final Logger log = LoggerFactory.getLogger(ConsumeConfigChangeListener.class);
    @Autowired
    private AbstractConsumerContainer consumerContainer;
    @Value(value="${ark.mq.consume.restart.max-delay-time:60}")
    private Integer restartMaxDelayTime;
    private ConcurrentHashMap<String, List<MQPropertyModel>> map = new ConcurrentHashMap();

    public ConsumeConfigChangeListener(AbstractConsumerContainer consumerContainer) {
        this.consumerContainer = consumerContainer;
    }

    public void init() {
        Field[] fieldList = FsConsumerModelProperties.class.getDeclaredFields();
        Arrays.stream(fieldList).forEach(f -> f.setAccessible(true));
        List<IFshowsConsumer> list = this.consumerContainer.getFshowsConsumerList();
        for (IFshowsConsumer consumer : list) {
            FsConsumerModel consumerModel = consumer.getConsumerModel();
            FsConsumerConfigKey consumerConfigKey = consumerModel.getConsumerConfigKey();
            FsConsumerModelProperties consumerModelProperties = consumerModel.getConsumerProperties();
            for (Field field : fieldList) {
                String key = ConfigUtil.getDynamicKey(this.getFieldValueStr(consumerConfigKey, field));
                if (key == null) continue;
                String value = this.getFieldValueStr(consumerModelProperties, field);
                MQPropertyModel propertyModel = new MQPropertyModel();
                propertyModel.setTarget(consumerModelProperties);
                propertyModel.setField(field);
                propertyModel.setKey(key);
                propertyModel.setValue(value);
                propertyModel.setFshowsConsumer(consumer);
                this.put(key, propertyModel);
            }
        }
    }

    public String getFieldValueStr(Object target, Field field) {
        try {
            Object value = field.get(target);
            return value == null ? null : value.toString();
        }
        catch (IllegalAccessException e) {
            log.error("ark-spring-boot-starter >> mq\u6d88\u8d39\u8005\u914d\u7f6e\u53d8\u66f4\u76d1\u542c\u5668\u52a0\u8f7d\u5f02\u5e38!", (Throwable)e);
            throw new MQConsumerException("ark-spring-boot-starter >> mq\u6d88\u8d39\u8005\u914d\u7f6e\u53d8\u66f4\u76d1\u542c\u5668\u52a0\u8f7d\u5f02\u5e38\uff01");
        }
    }

    private void put(String key, MQPropertyModel mqPropertyModel) {
        List<MQPropertyModel> propertyModelList = this.map.get(key);
        if (propertyModelList == null) {
            propertyModelList = new ArrayList<MQPropertyModel>();
        }
        propertyModelList.add(mqPropertyModel);
        this.map.put(key, propertyModelList);
    }

    public void reloadConfig(List<ConfigChangeModel> configChangeModelList) {
        if (configChangeModelList == null) {
            return;
        }
        if (this.map.size() == 0) {
            this.init();
        }
        HashSet<IFshowsConsumer> reloadConsumerSet = new HashSet<IFshowsConsumer>();
        for (ConfigChangeModel configChangeModel : configChangeModelList) {
            reloadConsumerSet.addAll(this.setMQPropertyNewVaule(configChangeModel));
        }
        if (reloadConsumerSet.size() == 0) {
            log.info("ark-spring-boot-starter >> \u672a\u5c06\u6d4b\u5230mq\u76f8\u5173\u914d\u7f6e\u66f4\u65b0, \u672c\u6b21\u914d\u7f6e\u53d8\u66f4\u4e0d\u5237\u65b0consumer\u5b9e\u4f8b\uff01");
            return;
        }
        int restartDelayTime = new Random().nextInt(this.restartMaxDelayTime);
        log.info("ark-spring-boot-starter >> \u68c0\u6d4b\u5230\u914d\u7f6e\u66f4\u65b0,{}\u79d2\u949f\u540e\u5f00\u59cb\u91cd\u542fconsumer\u5b9e\u4f8b\uff01", (Object)restartDelayTime);
        ThreadUtil.sleep(restartDelayTime);
        reloadConsumerSet.forEach(IFshowsConsumer::restart);
        log.info("ark-spring-boot-starter >> consumer\u5b9e\u4f8b\u91cd\u542f\u5b8c\u6210\uff01");
    }

    public List<IFshowsConsumer> setMQPropertyNewVaule(ConfigChangeModel configChangeModel) {
        if (StrUtil.isBlank(configChangeModel.getNewValue())) {
            return new ArrayList<IFshowsConsumer>();
        }
        String key = configChangeModel.getKey();
        List<MQPropertyModel> list = this.map.get(key);
        if (list == null) {
            return new ArrayList<IFshowsConsumer>();
        }
        ArrayList<IFshowsConsumer> updateConsumer = new ArrayList<IFshowsConsumer>();
        for (MQPropertyModel mqPropertyModel : list) {
            boolean bo;
            if (configChangeModel.getNewValue().equals(mqPropertyModel.getValue()) || !(bo = this.setFieldValueStr(configChangeModel.getNewValue(), mqPropertyModel.getTarget(), mqPropertyModel.getField()))) continue;
            mqPropertyModel.setValue(configChangeModel.getNewValue());
            updateConsumer.add(mqPropertyModel.getFshowsConsumer());
        }
        return updateConsumer;
    }

    public boolean setFieldValueStr(String value, Object target, Field field) {
        try {
            field.set(target, value);
            return true;
        }
        catch (IllegalAccessException e) {
            log.error("ark-spring-boot-starter >> mq\u6d88\u8d39\u8005\u914d\u7f6e\u53d8\u66f4\u76d1\u542c\u5668\u5f02\u5e38 >> \u52a8\u6001\u52a0\u8f7d\u53d8\u66f4\u914d\u7f6e\u5f02\u5e38 >> value={}", (Object)value);
            return false;
        }
    }
}

