/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.core.mq.rocketmq.consumer;

import com.aliyun.openservices.ons.api.bean.ConsumerBean;
import com.aliyun.openservices.ons.api.bean.Subscription;
import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.FsConsumerModel;
import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.FsConsumerModelProperties;
import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.IFshowsConsumer;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.consumer.AbstractConsumerContainer;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.consumer.AliyunFshowsConsumerImpl;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.consumer.RocketListenerProxy;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultConsumeContainerImpl
extends AbstractConsumerContainer {
    private ConcurrentHashMap<String, ConsumerBean> consumeMap = new ConcurrentHashMap(16);

    @Override
    protected IFshowsConsumer doCreateIFshowsConsumer(FsConsumerModel consumerModel) {
        FsConsumerModelProperties fsConsumerModelProperties = consumerModel.getConsumerProperties();
        ConsumerBean consumerBean = this.consumeMap.get(consumerModel.getConsumerProperties().getGroupId());
        if (consumerBean != null) {
            return new AliyunFshowsConsumerImpl(consumerBean, consumerModel);
        }
        consumerBean = new ConsumerBean();
        Properties properties = new Properties();
        properties.setProperty("GROUP_ID", fsConsumerModelProperties.getGroupId());
        properties.setProperty("AccessKey", fsConsumerModelProperties.getAccessKey());
        properties.setProperty("SecretKey", fsConsumerModelProperties.getSecretKey());
        properties.setProperty("NAMESRV_ADDR", fsConsumerModelProperties.getNamesrvAddr());
        properties.setProperty("maxReconsumeTimes", fsConsumerModelProperties.getMaxReconsumeTimes());
        properties.setProperty("ConsumeThreadNums", fsConsumerModelProperties.getConsumeThreadNums());
        properties.setProperty("consumeTimeout", fsConsumerModelProperties.getConsumeTimeout());
        consumerBean.setProperties(properties);
        this.bindSubscriptionMethod(consumerModel, consumerBean);
        this.consumeMap.put(consumerModel.getConsumerProperties().getGroupId(), consumerBean);
        return new AliyunFshowsConsumerImpl(consumerBean, consumerModel);
    }

    private void bindSubscriptionMethod(FsConsumerModel fsConsumerModel, ConsumerBean consumerBean) {
        FsConsumerModelProperties fsConsumerModelProperties = fsConsumerModel.getConsumerProperties();
        Map<Subscription, RocketListenerProxy> subscriptionTable = consumerBean.getSubscriptionTable() == null ? new HashMap() : consumerBean.getSubscriptionTable();
        Subscription subscription = new Subscription();
        subscription.setTopic(fsConsumerModelProperties.getTopic());
        subscription.setExpression(fsConsumerModelProperties.getTags());
        subscriptionTable.put(subscription, new RocketListenerProxy(fsConsumerModel, this.consumerInterceptorManagement));
        consumerBean.setSubscriptionTable(subscriptionTable);
    }
}

