/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer;

import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsMessageSendContext;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsProducerInvoke;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsProducerModel;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendErrorCallback;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendResult;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendSuccessCallback;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.IFshowsProducer;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.TransactionMessageManage;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.RocketSendMessageMethodModel;
import com.fshows.ark.spring.boot.starter.enums.ProducerReturnTypeEnum;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketProducerProxyHandler
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(RocketProducerProxyHandler.class);
    private IFshowsProducer producer;
    private TransactionMessageManage transactionMessageManage;
    private FsProducerModel fsProducerModel;
    private Map<Method, RocketSendMessageMethodModel> sendMessageMethodMap;

    public RocketProducerProxyHandler(IFshowsProducer producer, FsProducerModel fsProducerModel, TransactionMessageManage transactionMessageManage) {
        this.producer = producer;
        this.sendMessageMethodMap = fsProducerModel.getSendMessageMethodModelMap();
        this.fsProducerModel = fsProducerModel;
        this.transactionMessageManage = transactionMessageManage;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Object.class.equals(method.getDeclaringClass())) {
            return method.invoke((Object)this, args);
        }
        RocketSendMessageMethodModel sendMessageMethod = this.sendMessageMethodMap.get(method);
        FsMessageSendContext messageSendcontext = this.buildMessageSendContext(sendMessageMethod, args);
        FsSendResult sendResult = this.sendMessage(messageSendcontext, this.producer);
        return ProducerReturnTypeEnum.VOID.equals((Object)sendMessageMethod.getReturnTypeEnum()) ? null : sendResult;
    }

    private FsSendResult sendMessage(FsMessageSendContext messageSendcontext, IFshowsProducer producer) {
        FsSendResult sendResult = producer.send(messageSendcontext);
        return sendResult;
    }

    private FsMessageSendContext buildMessageSendContext(RocketSendMessageMethodModel rocketSendMessageMethodModel, Object[] args) {
        FsMessageSendContext context = new FsMessageSendContext();
        context.setRocketSendMessageMethodModel(rocketSendMessageMethodModel);
        context.setProducerSendTypeEnum(rocketSendMessageMethodModel.getSendTypeEnum());
        context.setProducerTypeEnum(rocketSendMessageMethodModel.getProducerTypeEnum());
        FsProducerInvoke producerInvoke = rocketSendMessageMethodModel.getParamTypeEnum().getFsProducerInvoke();
        FsSendSuccessCallback successCallback = producerInvoke.buildFsSendSuccessCallback(rocketSendMessageMethodModel, args);
        context.setSuccessCallback(successCallback);
        FsSendErrorCallback errorCallback = producerInvoke.buildFsSendErrorCallback(rocketSendMessageMethodModel, args);
        context.setErrorCallback(errorCallback);
        FsMessage fsMessage = producerInvoke.buildFsMessage(rocketSendMessageMethodModel, args);
        context.setFsMessage(fsMessage);
        return context;
    }
}

