/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.core.mq.rocketmq.interceptor.consumer;

import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage;
import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.FsConsumerInterceptor;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.interceptor.consumer.IConsumerInterceptorManagement;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public class DefaultConsumerInterceptorManagement
implements IConsumerInterceptorManagement,
ApplicationContextAware,
InitializingBean {
    private ApplicationContext applicationContext;
    private List<FsConsumerInterceptor> interceptorList = new CopyOnWriteArrayList<FsConsumerInterceptor>();

    public void afterPropertiesSet() throws Exception {
        Map map = this.applicationContext.getBeansOfType(FsConsumerInterceptor.class);
        if (map != null) {
            map.values().stream().forEach(this.interceptorList::add);
        }
        AnnotationAwareOrderComparator.sort(this.interceptorList);
    }

    @Override
    public void registerInterceptor(FsConsumerInterceptor fsConsumerInterceptor) {
        if (fsConsumerInterceptor != null) {
            this.interceptorList.add(fsConsumerInterceptor);
            AnnotationAwareOrderComparator.sort(this.interceptorList);
        }
    }

    @Override
    public List<FsConsumerInterceptor> getAllInterceptor() {
        return this.interceptorList;
    }

    @Override
    public void doBeforeConsume(FsMessage fsMessage) {
        for (FsConsumerInterceptor consumerInterceptor : this.interceptorList) {
            consumerInterceptor.beforeConsume(fsMessage);
        }
    }

    @Override
    public void doAfterConsume(FsMessage fsMessage, boolean consumeResult) {
        for (FsConsumerInterceptor consumerInterceptor : this.interceptorList) {
            consumerInterceptor.afterConsume(fsMessage, consumeResult);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

