/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.core.mq.rocketmq.consumer;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage;
import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.FsConsumerModel;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.interceptor.consumer.IConsumerInterceptorManagement;
import com.fshows.ark.spring.boot.starter.enums.ConsumerParamTypeEnum;
import com.fshows.ark.spring.boot.starter.enums.ConsumerReturnTypeEnum;
import com.fshows.ark.spring.boot.starter.exception.MQConsumerException;
import com.fshows.ark.spring.boot.starter.util.LogUtil;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketListenerProxy
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(RocketListenerProxy.class);
    private IConsumerInterceptorManagement consumerInterceptorManagement;
    private FsConsumerModel consumerModel;
    private Method m;
    private Object target;

    public RocketListenerProxy(FsConsumerModel consumerModel, IConsumerInterceptorManagement consumerInterceptorManagement) {
        this.m = consumerModel.getListenerMethod();
        this.target = consumerModel.getTarget();
        this.consumerModel = consumerModel;
        this.consumerInterceptorManagement = consumerInterceptorManagement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Action consume(Message message, ConsumeContext context) {
        Action action = Action.ReconsumeLater;
        FsMessage fsMessage = this.convertMessage(message);
        try {
            if (this.consumerInterceptorManagement != null) {
                this.consumerInterceptorManagement.doBeforeConsume(fsMessage);
            }
            Object[] methodParam = this.createMethodParam(message, fsMessage);
            if (ConsumerReturnTypeEnum.VOID.equals((Object)this.consumerModel.getReturnTypeEnum())) {
                this.m.invoke(this.target, methodParam);
                action = Action.CommitMessage;
            } else if (ConsumerReturnTypeEnum.ALIYUN_ACTION.equals((Object)this.consumerModel.getReturnTypeEnum())) {
                Object o = this.m.invoke(this.target, methodParam);
                action = (Action)o;
            } else if (ConsumerReturnTypeEnum.BOOLEAN.equals((Object)this.consumerModel.getReturnTypeEnum())) {
                Boolean bo = (Boolean)this.m.invoke(this.target, methodParam);
                action = Boolean.TRUE.equals(bo) ? Action.CommitMessage : Action.ReconsumeLater;
            }
        }
        catch (IllegalAccessException e) {
            LogUtil.error(log, "ark-spring-boot-starter >> \u6d88\u8d39\u8005\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff0c\u65e0\u8bbf\u95ee\u6743\u9650\uff01class={},m={}", e, this.target.getClass().getName(), this.m.getName());
        }
        catch (InvocationTargetException e) {
            LogUtil.error(log, "ark-spring-boot-starter >> \u6d88\u8d39\u8005\u4e1a\u52a1\u5f02\u5e38\uff01class={},m={}", e.getTargetException(), this.target.getClass().getName(), this.m.getName());
        }
        catch (Throwable e) {
            LogUtil.error(log, "ark-spring-boot-starter >> \u6d88\u8d39\u8005\u4e1a\u52a1\u5f02\u5e38\uff01class={},m={}", e, this.target.getClass().getName(), this.m.getName());
        }
        finally {
            if (this.consumerInterceptorManagement != null) {
                this.consumerInterceptorManagement.doAfterConsume(fsMessage, Action.ReconsumeLater.equals((Object)action));
            }
        }
        return action;
    }

    private Object[] createMethodParam(Message message, FsMessage fsMessage) {
        if (ConsumerParamTypeEnum.ALIYUN_MESSAGE.equals((Object)this.consumerModel.getParamTypeEnum())) {
            return new Object[]{message};
        }
        if (ConsumerParamTypeEnum.FS_MESSAGE.equals((Object)this.consumerModel.getParamTypeEnum())) {
            return new Object[]{fsMessage};
        }
        if (ConsumerParamTypeEnum.MESSAGE_BODY_STRING.equals((Object)this.consumerModel.getParamTypeEnum())) {
            return new Object[]{fsMessage.getContent()};
        }
        return null;
    }

    private FsMessage convertMessage(Message message) {
        FsMessage fsMessage = new FsMessage();
        fsMessage.setTag(message.getTag());
        fsMessage.setTopic(message.getTopic());
        fsMessage.setReconsumeTimes(message.getReconsumeTimes());
        fsMessage.setSendTime(message.getStartDeliverTime() != 0L ? message.getStartDeliverTime() : message.getBornTimestamp());
        try {
            fsMessage.setContent(new String(message.getBody(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.error(log, "ark-spring-boot-starter >> \u6d88\u8d39\u8005\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff0c\u6d88\u606f\u5185\u5bb9\u63d0\u53d6\u5931\u8d25\uff01message={},m={}.{}()", e, message, this.target.getClass().getName(), this.m.getName());
            throw new MQConsumerException("ark-spring-boot-starter >> \u6d88\u8d39\u8005\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff0c\u6d88\u606f\u5185\u5bb9\u63d0\u53d6\u5931\u8d25");
        }
        fsMessage.setExtendParam(message.getUserProperties());
        return fsMessage;
    }
}

