/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.core.mq.rocketmq.consumer;

import com.fshows.ark.spring.boot.starter.annotation.mq.RocketConsumer;
import com.fshows.ark.spring.boot.starter.annotation.mq.RocketListener;
import com.fshows.ark.spring.boot.starter.core.mq.base.FsMqCustomConfig;
import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.FsConsumerConfigKey;
import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.FsConsumerModel;
import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.FsConsumerModelProperties;
import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.IFshowsConsumer;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.interceptor.consumer.IConsumerInterceptorManagement;
import com.fshows.ark.spring.boot.starter.enums.ConsumerParamTypeEnum;
import com.fshows.ark.spring.boot.starter.enums.ConsumerReturnTypeEnum;
import com.fshows.ark.spring.boot.starter.exception.MQConsumerException;
import com.fshows.ark.spring.boot.starter.util.ConfigUtil;
import com.fshows.ark.spring.boot.starter.util.LogUtil;
import com.fshows.ark.spring.boot.starter.util.StrUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractConsumerContainer
implements ApplicationRunner,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(AbstractConsumerContainer.class);
    private ApplicationContext ctx;
    protected IConsumerInterceptorManagement consumerInterceptorManagement;
    private ConcurrentHashMap<String, IFshowsConsumer> fshowsConsumerMap = new ConcurrentHashMap(16);

    public void run(ApplicationArguments args) throws Exception {
        Map rocketConsumer = this.ctx.getBeansWithAnnotation(RocketConsumer.class);
        if (rocketConsumer == null || rocketConsumer.size() == 0) {
            return;
        }
        this.checkMetaConfig();
        List<FsConsumerModel> fsConsumerModelList = this.resolveRocketConsumeModel(rocketConsumer);
        if (fsConsumerModelList == null || fsConsumerModelList.size() == 0) {
            return;
        }
        List<IFshowsConsumer> consumerBeanList = fsConsumerModelList.stream().map(e -> this.createIFshowsConsumer((FsConsumerModel)e)).collect(Collectors.toList());
        this.consumeStart(consumerBeanList);
        log.info("ark-spring-boot-starter >> Rocket mq started successfully!");
    }

    public void checkMetaConfig() {
        String mqNameServer = ConfigUtil.getProperty("${ark.mq.name-server:}", this.ctx);
        if (mqNameServer == null || mqNameServer.length() == 0) {
            LogUtil.error(log, "ark-spring-boot-starter >> \u914d\u7f6e\u9879${ark.mq.name-server}MQ Name Server\u5730\u5740\u672a\u914d\u7f6e, \u542f\u52a8\u5931\u8d25\uff01");
            throw new MQConsumerException("ark-spring-boot-starter >> MQNameServer\u5730\u5740\u672a\u914d\u7f6e\uff01");
        }
        if (mqNameServer.contains("aliyuncs.com")) {
            String accessKey = ConfigUtil.getProperty("${ark.aliyun.access-key:none}", this.ctx);
            String secretKey = ConfigUtil.getProperty("${ark.aliyun.secret-key:none}", this.ctx);
            if ("none".equalsIgnoreCase(accessKey) || "none".equalsIgnoreCase(secretKey)) {
                LogUtil.error(log, "ark-spring-boot-starter >> \u542f\u52a8\u5931\u8d25 >> \u68c0\u6d4b\u5230\u4f7f\u7528\u963f\u91cc\u4e91MQ\u670d\u52a1\u5668,\u5fc5\u987b\u914d\u7f6e${ark.aliyun.access-key}\u548c${ark.aliyun.secret-key}\u914d\u7f6e\u9879\uff01");
                throw new MQConsumerException("ark-spring-boot-starter >> rocketmq\u6d88\u8d39\u8005\u521b\u5efa\u5931\u8d25\uff01");
            }
        }
    }

    protected void consumeStart(List<IFshowsConsumer> consumerBeanList) {
        if (consumerBeanList == null || consumerBeanList.size() == 0) {
            return;
        }
        consumerBeanList.parallelStream().forEach(consumerBean -> consumerBean.start());
    }

    protected IFshowsConsumer createIFshowsConsumer(FsConsumerModel fsConsumerModel) {
        FsConsumerModelProperties consumerProperties = fsConsumerModel.getConsumerProperties();
        IFshowsConsumer fshowsConsumer = this.fshowsConsumerMap.get(consumerProperties.getGroupId());
        if (fshowsConsumer != null) {
            return this.fshowsConsumerMap.get(consumerProperties.getGroupId());
        }
        fshowsConsumer = this.doCreateIFshowsConsumer(fsConsumerModel);
        this.fshowsConsumerMap.put(consumerProperties.getGroupId(), fshowsConsumer);
        return fshowsConsumer;
    }

    protected abstract IFshowsConsumer doCreateIFshowsConsumer(FsConsumerModel var1);

    protected List<FsConsumerModel> resolveRocketConsumeModel(Map<String, Object> rocketConsumer) {
        ArrayList<FsConsumerModel> list = new ArrayList<FsConsumerModel>();
        if (rocketConsumer == null) {
            return list;
        }
        for (Map.Entry<String, Object> entry : rocketConsumer.entrySet()) {
            Method[] methods;
            Object target = entry.getValue();
            RocketConsumer calssAnnotation = target.getClass().getAnnotation(RocketConsumer.class);
            String topic = calssAnnotation.topic();
            for (Method m : methods = target.getClass().getDeclaredMethods()) {
                RocketListener annotation = m.getAnnotation(RocketListener.class);
                if (annotation == null) continue;
                list.add(this.createRocketConsumerModel(entry.getKey(), entry.getValue(), m, annotation, topic));
            }
        }
        return list;
    }

    protected void checkRocketListener(Object target, Method listenerMethod) {
        if (listenerMethod.getParameterCount() != 1) {
            LogUtil.error(log, "ark-spring-boot-starter >> MQ\u6d88\u8d39\u51fd\u6570\u53c2\u6570\u6570\u91cf\u5fc5\u987b\u4e3a1,\u4e14\u7c7b\u578b\u5fc5\u987b\u4e3aFsMessage\u3001String\u3001\u963f\u91cc\u4e91\u7684Message\u5176\u4e2d\u4e4b\u4e00! {}.{}", target.getClass().getName(), listenerMethod.getName());
            throw new MQConsumerException("ark-spring-boot-starter >> rocketmq\u6d88\u8d39\u8005\u521b\u5efa\u5931\u8d25\uff01");
        }
        Class<?> patameterType = listenerMethod.getParameterTypes()[0];
        if (ConsumerParamTypeEnum.getByValue(patameterType.getName()) == null) {
            LogUtil.error(log, "ark-spring-boot-starter >> MQ\u6d88\u8d39\u51fd\u6570\u53c2\u6570\u6570\u91cf\u5fc5\u987b\u4e3a1,\u4e14\u7c7b\u578b\u5fc5\u987b\u4e3aFsMessage\u3001String\u3001\u963f\u91cc\u4e91\u7684Message\u5176\u4e2d\u4e4b\u4e00! {}.{}", target.getClass().getName(), listenerMethod.getName());
            throw new MQConsumerException("ark-spring-boot-starter >> rocketmq\u6d88\u8d39\u8005\u521b\u5efa\u5931\u8d25\uff01");
        }
        Class<?> returnType = listenerMethod.getReturnType();
        if (ConsumerReturnTypeEnum.getByValue(returnType.getName()) == null) {
            LogUtil.error(log, "ark-spring-boot-starter >> MQ\u6d88\u8d39\u51fd\u6570\u8fd4\u56de\u503c\u7c7b\u578b\u5fc5\u987b\u4e3a\u65e0\u8fd4\u56de\u503c(\u901a\u8fc7\u5f02\u5e38\u6765\u63a7\u5236\u6d88\u606f\u91cd\u65b0\u6d88\u8d39)\u6216\u8005\u963f\u91cc\u4e91\u7684com.aliyun.openservices.ons.api.Action! {}.{}", target.getClass().getName(), listenerMethod.getName());
            throw new MQConsumerException("ark-spring-boot-starter >> rocketmq\u6d88\u8d39\u8005\u521b\u5efa\u5931\u8d25\uff01");
        }
    }

    protected FsConsumerModel createRocketConsumerModel(String beanName, Object targetBean, Method listenerMethod, RocketListener listenerAnnotation, String topic) {
        String aliyunSecretKey;
        this.checkRocketListener(targetBean, listenerMethod);
        FsMqCustomConfig fsMqCustomConfig = ConfigUtil.getFsMqCustomConfig(this.ctx);
        String aliyunAccessKey = fsMqCustomConfig != null && "${ark.aliyun.access-key:none}".equals(listenerAnnotation.accessKey()) ? fsMqCustomConfig.getAliyunAccessKey() : listenerAnnotation.accessKey();
        String string = aliyunSecretKey = fsMqCustomConfig != null && "${ark.aliyun.secret-key:none}".equals(listenerAnnotation.secretKey()) ? fsMqCustomConfig.getAliyunSecretKey() : listenerAnnotation.secretKey();
        if (fsMqCustomConfig != null && "${ark.aliyun.access-key:none}".equals(listenerAnnotation.accessKey())) {
            log.debug("ark-spring-boot-starter >> \u4f7f\u7528\u81ea\u5b9a\u4e49\u5168\u5c40aliyunAccessKey,\u521d\u59cb\u5316\u6d88\u8d39\u8005 >> aliyunAccessKey={}", (Object)aliyunAccessKey);
        }
        FsConsumerModel fsConsumerModel = new FsConsumerModel();
        fsConsumerModel.setBeanName(beanName);
        fsConsumerModel.setListenerMethod(listenerMethod);
        fsConsumerModel.setTarget(targetBean);
        ConsumerParamTypeEnum paramTypeEnum = ConsumerParamTypeEnum.getByValue(listenerMethod.getParameterTypes()[0].getName());
        fsConsumerModel.setParamTypeEnum(paramTypeEnum);
        ConsumerReturnTypeEnum returnTypeEnum = ConsumerReturnTypeEnum.getByValue(listenerMethod.getReturnType().getName());
        fsConsumerModel.setReturnTypeEnum(returnTypeEnum);
        FsConsumerModelProperties consumerProperties = new FsConsumerModelProperties();
        consumerProperties.setGroupId(ConfigUtil.getProperty(listenerAnnotation.groupId(), this.ctx));
        consumerProperties.setTopic(ConfigUtil.getProperty(topic, this.ctx));
        consumerProperties.setTags(ConfigUtil.getProperty(listenerAnnotation.tags(), this.ctx));
        consumerProperties.setConsumeTimeout(ConfigUtil.getProperty(listenerAnnotation.consumeTimeout(), this.ctx));
        consumerProperties.setMaxReconsumeTimes(ConfigUtil.getProperty(listenerAnnotation.maxReconsumeTimes(), this.ctx));
        consumerProperties.setConsumeThreadNums(ConfigUtil.getProperty(listenerAnnotation.consumeThreadNums(), this.ctx));
        consumerProperties.setCharsetName(ConfigUtil.getProperty(listenerAnnotation.msgContentCharset(), this.ctx));
        consumerProperties.setAccessKey(ConfigUtil.getProperty(aliyunAccessKey, this.ctx));
        consumerProperties.setSecretKey(ConfigUtil.getProperty(aliyunSecretKey, this.ctx));
        consumerProperties.setNamesrvAddr(ConfigUtil.getProperty(listenerAnnotation.namesrvAddr(), this.ctx));
        fsConsumerModel.setConsumerProperties(consumerProperties);
        this.checkConsumerModelProperties(consumerProperties, fsConsumerModel, listenerAnnotation);
        FsConsumerConfigKey consumerConfigKey = new FsConsumerConfigKey();
        consumerConfigKey.setGroupId(ConfigUtil.isDynamicConfigKey(listenerAnnotation.groupId()));
        consumerConfigKey.setTopic(ConfigUtil.isDynamicConfigKey(topic));
        consumerConfigKey.setTags(ConfigUtil.isDynamicConfigKey(listenerAnnotation.tags()));
        consumerConfigKey.setConsumeTimeout(ConfigUtil.isDynamicConfigKey(listenerAnnotation.consumeTimeout()));
        consumerConfigKey.setMaxReconsumeTimes(ConfigUtil.isDynamicConfigKey(listenerAnnotation.maxReconsumeTimes()));
        consumerConfigKey.setConsumeThreadNums(ConfigUtil.isDynamicConfigKey(listenerAnnotation.consumeThreadNums()));
        consumerConfigKey.setCharsetName(ConfigUtil.isDynamicConfigKey(listenerAnnotation.msgContentCharset()));
        consumerConfigKey.setAccessKey(ConfigUtil.isDynamicConfigKey(listenerAnnotation.accessKey()));
        consumerConfigKey.setSecretKey(ConfigUtil.isDynamicConfigKey(listenerAnnotation.secretKey()));
        consumerConfigKey.setNamesrvAddr(ConfigUtil.isDynamicConfigKey(listenerAnnotation.namesrvAddr()));
        fsConsumerModel.setConsumerConfigKey(consumerConfigKey);
        return fsConsumerModel;
    }

    protected void checkConsumerModelProperties(FsConsumerModelProperties consumerProperties, FsConsumerModel fsConsumerModel, RocketListener listenerAnnotation) {
        if (StrUtil.isBlank(consumerProperties.getGroupId())) {
            LogUtil.error(log, "ark-spring-boot-starter >> mq\u6d88\u8d39\u8005groupId\u4e0d\u80fd\u4e3a\u7a7a\uff01 >> {}.{}", fsConsumerModel.getBeanName(), fsConsumerModel.getListenerMethod());
            throw new MQConsumerException("ark-spring-boot-starter >> mq\u6d88\u8d39\u8005groupId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isBlank(consumerProperties.getTags())) {
            LogUtil.error(log, "ark-spring-boot-starter >> mq\u6d88\u8d39\u8005tag\u4e0d\u80fd\u4e3a\u7a7a\uff01 >> {}.{}", fsConsumerModel.getBeanName(), fsConsumerModel.getListenerMethod());
            throw new MQConsumerException("ark-spring-boot-starter >> mq\u6d88\u8d39\u8005tag\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.ctx = applicationContext;
    }

    public void setConsumerInterceptorManagement(IConsumerInterceptorManagement consumerInterceptorManagement) {
        this.consumerInterceptorManagement = consumerInterceptorManagement;
    }

    public List<IFshowsConsumer> getFshowsConsumerList() {
        return new ArrayList<IFshowsConsumer>(this.fshowsConsumerMap.values());
    }
}

