/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.core.mq.base;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.OnExceptionContext;
import com.aliyun.openservices.ons.api.SendResult;
import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendExceptionHolder;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendResult;
import com.fshows.ark.spring.boot.starter.exception.MQMessageConvertException;
import com.fshows.ark.spring.boot.starter.util.StrUtil;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsMessageConvert {
    private static final Logger log = LoggerFactory.getLogger(FsMessageConvert.class);

    public static FsMessage convertFsMessage(Message message, String charsetName) {
        FsMessage fsMessage = new FsMessage();
        fsMessage.setTag(message.getTag());
        fsMessage.setTopic(message.getTopic());
        fsMessage.setKey(message.getKey());
        try {
            fsMessage.setContent(new String(message.getBody(), charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new MQMessageConvertException("ark-spring-boot-starter >> \u963f\u91cc\u4e91Message \u8f6c FsMessage\u5931\u8d25, body\u5e8f\u5217\u5316\u4e3astring\u5931\u8d25!");
        }
        fsMessage.setExtendParam(message.getUserProperties());
        return fsMessage;
    }

    public static FsMessage convertFsMessage(Message message) {
        FsMessage fsMessage = new FsMessage();
        fsMessage.setTag(message.getTag());
        fsMessage.setTopic(message.getTopic());
        fsMessage.setKey(message.getKey());
        fsMessage.setContentBody(message.getBody());
        fsMessage.setExtendParam(message.getUserProperties());
        return fsMessage;
    }

    public static Message convertMessage(FsMessage fsMessage, String charsetName) {
        if (fsMessage == null) {
            return null;
        }
        Message message = fsMessage.getExtendParam() != null && fsMessage.getExtendParam().containsKey("@@@ALIYUN_ORIGINAL_MESSAGE@@@") ? (Message)fsMessage.getExtendParam().get("@@@ALIYUN_ORIGINAL_MESSAGE@@@") : new Message();
        message.setTag(fsMessage.getTag());
        message.setTopic(fsMessage.getTopic());
        message.setKey(fsMessage.getKey());
        try {
            if (fsMessage.getContentBody() != null) {
                message.setBody(fsMessage.getContentBody());
            } else if (fsMessage.getContent() != null) {
                message.setBody(fsMessage.getContent().getBytes(charsetName));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new MQMessageConvertException("ark-spring-boot-starter >> FsMessage \u8f6c \u963f\u91cc\u4e91Message , contentString\u53cd\u5e8f\u5217\u5316\u4e3astring\u5931\u8d25!");
        }
        if (fsMessage.getExtendParam() != null) {
            for (Map.Entry<Object, Object> entry : fsMessage.getExtendParam().entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                message.putUserProperties(StrUtil.ifNullDefaultEmpty(entry.getKey()), StrUtil.ifNullDefaultEmpty(entry.getValue()));
            }
        }
        if (fsMessage.getSendTime() > 0L) {
            message.setStartDeliverTime(fsMessage.getSendTime().longValue());
        }
        return message;
    }

    public static FsSendResult convertFsSendResult(SendResult sendResult) {
        FsSendResult fsSendResult = new FsSendResult();
        fsSendResult.setSuccess(true);
        fsSendResult.setTopic(sendResult.getTopic());
        fsSendResult.setMessageId(sendResult.getMessageId());
        return fsSendResult;
    }

    public static FsSendResult buildSendResult(FsMessage fsMessage, boolean success) {
        FsSendResult fsSendResult = new FsSendResult();
        fsSendResult.setSuccess(success);
        fsSendResult.setTopic(fsMessage.getTopic());
        return fsSendResult;
    }

    public static FsSendExceptionHolder convertFsSendExceptionContext(OnExceptionContext onExceptionContext) {
        FsSendExceptionHolder context = new FsSendExceptionHolder();
        context.setTopic(onExceptionContext.getTopic());
        context.setMessageId(onExceptionContext.getMessageId());
        context.setException((Exception)onExceptionContext.getException());
        return context;
    }

    public static FsSendResult convertFsSendResult(OnExceptionContext onExceptionContext) {
        FsSendResult fsSendResult = new FsSendResult();
        fsSendResult.setSuccess(false);
        fsSendResult.setTopic(onExceptionContext.getTopic());
        fsSendResult.setMessageId(onExceptionContext.getMessageId());
        fsSendResult.setEx((Exception)onExceptionContext.getException());
        return fsSendResult;
    }
}

