/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.core.sensitive.encrypt.interceptor;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.fshows.ark.spring.boot.starter.annotation.encrypt.LifecircleEncrypt;
import com.fshows.ark.spring.boot.starter.core.sensitive.encrypt.DefaultFieldEncryptExecutor;
import com.fshows.ark.spring.boot.starter.core.sensitive.model.SensitiveTargetMethodEncryptFieldModel;
import com.fshows.ark.spring.boot.starter.util.LogUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.defaults.DefaultSqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(type=ParameterHandler.class, method="setParameters", args={PreparedStatement.class})})
public class EncryptInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(EncryptInterceptor.class);
    private static final Map<String, Map<String, SensitiveTargetMethodEncryptFieldModel>> ENCRYPT_FIELD_METHOD_CACHE = new ConcurrentHashMap<String, Map<String, SensitiveTargetMethodEncryptFieldModel>>();
    private static final Map<String, SensitiveTargetMethodEncryptFieldModel> DEFAULT_TARGET_METHOD_ENCRYPT_FIELD_MODEL_MAP = new HashMap<String, SensitiveTargetMethodEncryptFieldModel>();
    @Autowired
    private DefaultFieldEncryptExecutor defaultFieldEncryptExecutor;

    public Object intercept(Invocation invocation) throws Throwable {
        ParameterHandler parameterHandler;
        Object mappedStatement;
        if (invocation.getTarget() instanceof ParameterHandler && (mappedStatement = ReflectUtil.getFieldValue((Object)(parameterHandler = (ParameterHandler)invocation.getTarget()), (String)"mappedStatement")) instanceof MappedStatement) {
            Field parameterField = parameterHandler.getClass().getDeclaredField("parameterObject");
            parameterField.setAccessible(true);
            Object parameterObject = parameterField.get(parameterHandler);
            if (parameterObject != null) {
                if (parameterObject instanceof MapperMethod.ParamMap) {
                    Map<String, SensitiveTargetMethodEncryptFieldModel> targetMethodEncryptFieldMap;
                    String mapperFullName = ((MappedStatement)mappedStatement).getId();
                    int lastPoint = mapperFullName.lastIndexOf(".");
                    String className = mapperFullName.substring(0, lastPoint);
                    String methodName = mapperFullName.substring(lastPoint + 1);
                    String methodNamePath = className + "#" + methodName;
                    if (!ENCRYPT_FIELD_METHOD_CACHE.containsKey(methodNamePath)) {
                        targetMethodEncryptFieldMap = this.getTargetMethodEncryptFieldMap(className, methodName);
                        ENCRYPT_FIELD_METHOD_CACHE.put(methodNamePath, targetMethodEncryptFieldMap);
                    }
                    if (DEFAULT_TARGET_METHOD_ENCRYPT_FIELD_MODEL_MAP != (targetMethodEncryptFieldMap = ENCRYPT_FIELD_METHOD_CACHE.get(methodNamePath))) {
                        MapperMethod.ParamMap paramMap = (MapperMethod.ParamMap)parameterObject;
                        for (Map.Entry entry : paramMap.entrySet()) {
                            SensitiveTargetMethodEncryptFieldModel targetMethodEncryptFieldModel = targetMethodEncryptFieldMap.get(entry.getKey());
                            if (targetMethodEncryptFieldModel == null) continue;
                            LifecircleEncrypt.EncryptContentTypeEnum encryptContentTypeEnum = LifecircleEncrypt.EncryptContentTypeEnum.getByValue(targetMethodEncryptFieldModel.getEncryptContentType());
                            String encryptValue = LifecircleEncrypt.EncryptContentTypeEnum.SEARCH_KEYWORD.equals((Object)encryptContentTypeEnum) ? this.defaultFieldEncryptExecutor.encryptSearchKeywords(entry.getValue().toString()) : this.defaultFieldEncryptExecutor.encrypt(entry.getValue().toString());
                            entry.setValue(encryptValue);
                        }
                    }
                } else if (parameterObject instanceof DefaultSqlSession.StrictMap) {
                    Object arrayObject;
                    Object listObject;
                    Object collectionObject;
                    DefaultSqlSession.StrictMap strictMap = (DefaultSqlSession.StrictMap)parameterObject;
                    if (strictMap.containsKey((Object)"collection") && (collectionObject = strictMap.get((Object)"collection")) instanceof List) {
                        for (Object collectionNext : (List)collectionObject) {
                            this.resetObjectEncryptField(collectionNext);
                        }
                    }
                    if (strictMap.containsKey((Object)"list") && (listObject = strictMap.get((Object)"list")) instanceof List) {
                        for (Object listNext : (List)listObject) {
                            this.resetObjectEncryptField(listNext);
                        }
                    }
                    if (strictMap.containsKey((Object)"array") && (arrayObject = strictMap.get((Object)"array")).getClass().isArray()) {
                        Object[] array;
                        for (Object arrayNext : array = (Object[])arrayObject) {
                            this.resetObjectEncryptField(arrayNext);
                        }
                    }
                } else {
                    this.resetObjectEncryptField(parameterObject);
                }
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private Map<String, SensitiveTargetMethodEncryptFieldModel> getTargetMethodEncryptFieldMap(String className, String methodName) {
        Map<String, SensitiveTargetMethodEncryptFieldModel> targetMethodEncryptFieldModelMap = DEFAULT_TARGET_METHOD_ENCRYPT_FIELD_MODEL_MAP;
        try {
            Class<?> aClass = Class.forName(className);
            for (Method method : aClass.getDeclaredMethods()) {
                if (!StrUtil.equals((CharSequence)method.getName(), (CharSequence)methodName)) continue;
                Class<?>[] parameterTypes = method.getParameterTypes();
                for (int paramIndex = 0; paramIndex < parameterTypes.length; ++paramIndex) {
                    Class<?> parameterType = parameterTypes[paramIndex];
                    if (!String.class.isAssignableFrom(parameterType)) continue;
                    String name = null;
                    String secretName = null;
                    String encryptContentType = null;
                    for (Annotation annotation : method.getParameterAnnotations()[paramIndex]) {
                        if (annotation instanceof Param) {
                            name = ((Param)annotation).value();
                        }
                        if (annotation instanceof LifecircleEncrypt) {
                            secretName = ((LifecircleEncrypt)annotation).value();
                            encryptContentType = ((LifecircleEncrypt)annotation).encryptContentType().getValue();
                        }
                        if (!StrUtil.isNotBlank((CharSequence)name) || !StrUtil.isNotBlank((CharSequence)secretName)) continue;
                        targetMethodEncryptFieldModelMap.put(name, SensitiveTargetMethodEncryptFieldModel.builder().paramName(name).secretName(secretName).encryptContentType(encryptContentType).build());
                    }
                }
            }
        }
        catch (ClassNotFoundException e) {
            LogUtil.error(log, "ark-spring-boot-starter >> getTargetMethodEncryptFieldMap >> \u83b7\u53d6DOMapper\u76ee\u6807\u65b9\u6cd5\u7684\u52a0\u5bc6\u5b57\u6bb5map\u53d1\u751f\u5f02\u5e38 >> className={}, methodName={}", e, className, methodName);
        }
        return targetMethodEncryptFieldModelMap;
    }

    private void resetObjectEncryptField(Object object) throws IllegalAccessException {
        if (object != null) {
            Field[] declaredFields;
            for (Field field : declaredFields = object.getClass().getDeclaredFields()) {
                LifecircleEncrypt encryptField = field.getAnnotation(LifecircleEncrypt.class);
                if (!ObjectUtil.isNotNull((Object)encryptField)) continue;
                field.setAccessible(true);
                Object fieldValue = field.get(object);
                if (!(fieldValue instanceof String)) continue;
                String encryptValue = LifecircleEncrypt.EncryptContentTypeEnum.SEARCH_KEYWORD.equals((Object)encryptField.encryptContentType()) ? this.defaultFieldEncryptExecutor.encryptSearchKeywords(fieldValue.toString()) : this.defaultFieldEncryptExecutor.encrypt(fieldValue.toString());
                field.set(object, encryptValue);
            }
        }
    }
}

