/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.configuration;

import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.Producer;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.IProducerProxyFactory;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.consumer.AbstractConsumerContainer;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.consumer.DefaultConsumeContainerImpl;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.interceptor.DefaultProducerInterceptorManagement;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.interceptor.IProducerInterceptorManagement;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.interceptor.consumer.DefaultConsumerInterceptorManagement;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.interceptor.consumer.IConsumerInterceptorManagement;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.DefaultProducerProxyFactoryImpl;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.ProducerScannerRegistrar;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.transaction.TransactionMessageDao;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.transaction.TransactionMessageDaoImpl;
import com.fshows.ark.spring.boot.starter.extend.mq.configlistener.ConsumeConfigChangeListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(value={Producer.class, Consumer.class})
@Import(value={ProducerScannerRegistrar.class})
public class RocketMQAutoConfiguration {
    @Bean
    public AbstractConsumerContainer initConsumer(@Autowired(required=false) IConsumerInterceptorManagement consumerInterceptorManagement) {
        DefaultConsumeContainerImpl consumeContainer = new DefaultConsumeContainerImpl();
        consumeContainer.setConsumerInterceptorManagement(consumerInterceptorManagement);
        return consumeContainer;
    }

    @Bean
    public IProducerProxyFactory DefaultProducerProxyFactoryImpl(@Autowired(required=false) IProducerInterceptorManagement producerInterceptorManagement) {
        DefaultProducerProxyFactoryImpl defaultProducerProxyFactory = new DefaultProducerProxyFactoryImpl();
        defaultProducerProxyFactory.setProducerInterceptorManagement(producerInterceptorManagement);
        return defaultProducerProxyFactory;
    }

    @Bean
    public IProducerInterceptorManagement defaultProducerInterceptorManagement() {
        return new DefaultProducerInterceptorManagement();
    }

    @Bean
    public IConsumerInterceptorManagement defaultConsumerInterceptorManagement() {
        return new DefaultConsumerInterceptorManagement();
    }

    @Bean
    public TransactionMessageDao transactionMessageDao() {
        return new TransactionMessageDaoImpl();
    }

    @Bean
    public ConsumeConfigChangeListener consumeConfigChangeListener(@Autowired(required=false) AbstractConsumerContainer abstractConsumerContainer) {
        return new ConsumeConfigChangeListener(abstractConsumerContainer);
    }
}

