package com.fshows.ark.spring.boot.starter.core.sensitive.encrypt.interceptor;

import com.fshows.ark.spring.boot.starter.annotation.encrypt.LifecircleEncrypt;
import com.fshows.ark.spring.boot.starter.core.sensitive.encrypt.DefaultFieldEncryptExecutor;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.lang.reflect.Field;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;

/**
 * 敏感字段解密拦截器
 *
 * @author zhaoxumin
 * @version DecryptInterceptor.java, v 0.1 2024-05-29 21:55 zhaoxumin
 */
@Component
@Intercepts(
        @Signature(type = ResultSetHandler.class, method = "handleResultSets", args = {Statement.class})
)
public class DecryptInterceptor implements Interceptor {

    @Autowired
    private DefaultFieldEncryptExecutor defaultFieldEncryptExecutor;

    @Override
    public Object intercept(Invocation invocation) throws Throwable {
        // 取出查询的结果
        Object resultObject = invocation.proceed();
        if (resultObject == null) {
            return null;
        }
        // 基于selectList
        if (resultObject instanceof ArrayList) {
            ArrayList resultList = (ArrayList) resultObject;
            if (!CollectionUtils.isEmpty(resultList)) {
                for (Object result : resultList) {
                    Class<?> resultClass = result.getClass();
                    Field[] declaredFields = resultClass.getDeclaredFields();
                    for (Field field : declaredFields) {
                        // 取出所有被LifecircleEncrypt注解的字段
                        LifecircleEncrypt encryptField = field.getAnnotation(LifecircleEncrypt.class);
                        if (encryptField != null) {
                            field.setAccessible(true);
                            Object object = field.get(result);
                            // 只支持String的解密
                            if (object instanceof String) {
                                String value = (String) object;
                                // 对注解的字段进行逐一解密
                                field.set(result, defaultFieldEncryptExecutor.decrypt(value));
                            }
                        }
                    }
                }
            }
        } else {
            Class<?> resultClass = resultObject.getClass();
            Field[] declaredFields = resultClass.getDeclaredFields();
            for (Field field : declaredFields) {
                // 取出所有被LifecircleEncrypt注解的字段
                LifecircleEncrypt encryptField = field.getAnnotation(LifecircleEncrypt.class);
                if (encryptField != null) {
                    field.setAccessible(true);
                    Object object = field.get(resultObject);
                    // 只支持String的解密
                    if (object instanceof String) {
                        String value = (String) object;
                        // 对注解的字段进行逐一解密
                        field.set(resultObject, defaultFieldEncryptExecutor.decrypt(value));
                    }
                }
            }
        }
        return resultObject;
    }

    @Override
    public Object plugin(Object target) {
        return Plugin.wrap(target, this);
    }

    @Override
    public void setProperties(Properties properties) {

    }
}
