/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.sensitive.encrypt;

/**
 * 敏感数据加密执行器
 *
 * @author liluqing
 * @version FieldEncryptExecutor.java, v 0.1 2024-05-23 16:49
 */
public interface FieldEncryptExecutor {

    /**
     * 数据加密
     *
     * @param plaintext 明文
     * @return 密文
     */
    String encrypt(String plaintext);

    /**
     * 数据加密
     *
     * @param plaintext 明文
     * @return 密文
     */
    String encrypt(String plaintext, String secretName);

    /**
     * 加密用于检索的关键字
     *
     * 加密字段采取，为绑定like处理，采取了分段多次加密的策略，
     * 从第3位开始，列举字段加密
     *           eg. 123456 -> en(123)+en(1234)+en(12345)+en(123456)
     *
     * @param plaintext 明文
     * @return 密文
     */
    String encryptSearchKeywords(String plaintext);

    /**
     * 加密用于检索的关键字
     *
     * 加密字段采取，为绑定like处理，采取了分段多次加密的策略，
     * 从第3位开始，列举字段加密
     *           eg. 123456 -> en(123)+en(1234)+en(12345)+en(123456)
     *
     * @param plaintext 明文
     * @return 密文
     */
    String encryptSearchKeywords(String plaintext, String secretName);

    /**
     * 数据解密
     *
     * @param ciphertext 密文
     * @return 明文
     */
    String decrypt(String ciphertext);
}