/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.mq.rocketmq.interceptor;

import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsProducerInterceptor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

/**
 * 生产者拦截器管理器
 *
 * @author liluqing
 * @version DefaultProducerInterceptorManagement.java, v 0.1 2021-10-26 20:51
 */
public class DefaultProducerInterceptorManagement implements IProducerInterceptorManagement, ApplicationContextAware, InitializingBean {

    /**
     * spring上下文
     */
    private ApplicationContext applicationContext;

    /**
     * 拦截器列表
     */
    private List<FsProducerInterceptor> Interceptor = new CopyOnWriteArrayList<>();

    /**
     * 初始化生产者拦截器
     *
     * @throws Exception
     */
    @Override
    public void afterPropertiesSet() throws Exception {
        Map<String, FsProducerInterceptor> map = applicationContext.getBeansOfType(FsProducerInterceptor.class);
        if (map != null) {
            map.values().stream().forEach(Interceptor::add);
        }
        // 将拦截器按照spring的@Order注解进行排序
        AnnotationAwareOrderComparator.sort(Interceptor);
    }

    @Override
    public void registerInterceptor(FsProducerInterceptor fsProducerInterceptor) {
        if (fsProducerInterceptor != null) {
            Interceptor.add(fsProducerInterceptor);
        }
    }

    @Override
    public List<FsProducerInterceptor> getAllInterceptor() {
        return Interceptor;
    }

    @Override
    public ProducerInterceptorActuator getProducerInterceptorActuator() {
        return new DefaultProducerInterceptorActuator(Interceptor);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }


}