/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.mq.base.producer;

import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage;

/**
 * 事务消息发射台
 *
 * @author liluqing
 * @version ITtansactionProducer.java, v 0.1 2021-12-19 10:16
 */
public interface TransactionMessageManage {

    /**
     * 发送事务消息
     *
     * @param context 消息上下文
     * @return 发送结果，含消息Id, 消息主题
     */
    FsSendResult sendTransactionMsg(FsMessageSendContext context, TransactionCommitCallback transactionCommitCallback);

    /**
     * 更新消息发送状态到发送成功
     *
     * @param context
     * @return
     */
    boolean updateMsgSendStatusToSuccess(FsMessageSendContext context);

    /**
     * 判断当前线程是否处于事务中
     *
     * @return
     */
    boolean isInTransaction();
}