/**
 * fshows.com
 * Copyright (C) 2013-2019 All Rights Reserved.
 */
package com.fshows.ark.spring.boot.starter.configuration;

import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.Producer;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.IProducerProxyFactory;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.consumer.AbstractConsumerContainer;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.consumer.DefaultConsumeContainerImpl;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.interceptor.DefaultProducerInterceptorManagement;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.interceptor.IProducerInterceptorManagement;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.interceptor.consumer.DefaultConsumerInterceptorManagement;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.interceptor.consumer.IConsumerInterceptorManagement;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.DefaultProducerProxyFactoryImpl;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.ProducerScannerRegistrar;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.transaction.TransactionMessageDao;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.transaction.TransactionMessageDaoImpl;
import com.fshows.ark.spring.boot.starter.extend.mq.configlistener.ConsumeConfigChangeListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;


/**
 * rocketMQ自动化配置
 *
 * @author buhao
 * @version MQConfiguration.java, v 0.1 2019-06-20 14:43 buhao
 */
@Configuration
@ConditionalOnClass({Producer.class, Consumer.class})
@Import(ProducerScannerRegistrar.class)
public class RocketMQAutoConfiguration {

    /**
     * 消费者启动容器
     *
     * @return
     */
    @Bean
    public AbstractConsumerContainer initConsumer(@Autowired(required = false) IConsumerInterceptorManagement consumerInterceptorManagement) {
        DefaultConsumeContainerImpl consumeContainer = new DefaultConsumeContainerImpl();
        consumeContainer.setConsumerInterceptorManagement(consumerInterceptorManagement);
        return consumeContainer;
    }

    /**
     * 配置生产者默认代理工厂
     *
     * @return
     */
    @Bean
    public IProducerProxyFactory DefaultProducerProxyFactoryImpl(@Autowired(required = false) IProducerInterceptorManagement producerInterceptorManagement) {
        DefaultProducerProxyFactoryImpl defaultProducerProxyFactory = new DefaultProducerProxyFactoryImpl();
        defaultProducerProxyFactory.setProducerInterceptorManagement(producerInterceptorManagement);
        return defaultProducerProxyFactory;
    }

    @Bean
    public IProducerInterceptorManagement defaultProducerInterceptorManagement() {
        return new DefaultProducerInterceptorManagement();
    }

    @Bean
    public IConsumerInterceptorManagement defaultConsumerInterceptorManagement() {
        return new DefaultConsumerInterceptorManagement();
    }

    @Bean
    public TransactionMessageDao transactionMessageDao() {
        return new TransactionMessageDaoImpl();
    }

    @Bean
    public ConsumeConfigChangeListener consumeConfigChangeListener(@Autowired(required = false) AbstractConsumerContainer abstractConsumerContainer) {
        return new ConsumeConfigChangeListener(abstractConsumerContainer);
    }
}