/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.core.sensitive.encrypt.interceptor;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.fshows.ark.spring.boot.starter.annotation.encrypt.LifecircleEncrypt;
import com.fshows.ark.spring.boot.starter.core.sensitive.encrypt.DefaultFieldEncryptExecutor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(type=ParameterHandler.class, method="setParameters", args={PreparedStatement.class})})
public class EncryptInterceptor
implements Interceptor {
    @Autowired
    private DefaultFieldEncryptExecutor defaultFieldEncryptExecutor;

    public Object intercept(Invocation invocation) throws Throwable {
        block2: {
            Field[] declaredFields;
            Object parameterObject;
            block3: {
                String methodName;
                ParameterHandler parameterHandler;
                Object mappedStatement;
                if (!(invocation.getTarget() instanceof ParameterHandler) || !((mappedStatement = ReflectUtil.getFieldValue((Object)(parameterHandler = (ParameterHandler)invocation.getTarget()), (String)"mappedStatement")) instanceof MappedStatement)) break block2;
                Field parameterField = parameterHandler.getClass().getDeclaredField("parameterObject");
                parameterField.setAccessible(true);
                parameterObject = parameterField.get(parameterHandler);
                if (parameterObject == null) break block2;
                if (!(parameterObject instanceof MapperMethod.ParamMap)) break block3;
                String mapperFullName = ((MappedStatement)mappedStatement).getId();
                String className = mapperFullName.substring(0, mapperFullName.lastIndexOf("."));
                Map<String, String> targetMethodEncryptFieldMap = this.getTargetMethodEncryptFieldMap(className, methodName = mapperFullName.substring(mapperFullName.lastIndexOf(".") + 1));
                if (!CollUtil.isNotEmpty(targetMethodEncryptFieldMap)) break block2;
                MapperMethod.ParamMap paramMap = (MapperMethod.ParamMap)parameterObject;
                for (Map.Entry entry : paramMap.entrySet()) {
                    String key = (String)entry.getKey();
                    if (!targetMethodEncryptFieldMap.containsKey(className + "." + methodName + "." + key)) continue;
                    entry.setValue(this.defaultFieldEncryptExecutor.encrypt(entry.getValue().toString()));
                }
                break block2;
            }
            Class<?> parameterObjectClass = parameterObject.getClass();
            for (Field field : declaredFields = parameterObjectClass.getDeclaredFields()) {
                LifecircleEncrypt encryptField = field.getAnnotation(LifecircleEncrypt.class);
                if (!ObjectUtil.isNotNull((Object)encryptField)) continue;
                field.setAccessible(true);
                Object object = field.get(parameterObject);
                if (!(object instanceof String)) continue;
                String value = (String)object;
                field.set(parameterObject, this.defaultFieldEncryptExecutor.encrypt(value));
            }
        }
        return invocation.proceed();
    }

    private Map<String, String> getTargetMethodEncryptFieldMap(String className, String methodName) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        try {
            Class<?> aClass = Class.forName(className);
            for (Method method : aClass.getDeclaredMethods()) {
                if (!StrUtil.equals((CharSequence)method.getName(), (CharSequence)methodName)) continue;
                Class<?>[] parameterTypes = method.getParameterTypes();
                for (int paramIndex = 0; paramIndex < parameterTypes.length; ++paramIndex) {
                    Class<?> parameterType = parameterTypes[paramIndex];
                    if (!String.class.isAssignableFrom(parameterType)) continue;
                    String name = null;
                    String encryptTypeValue = null;
                    for (Annotation annotation : method.getParameterAnnotations()[paramIndex]) {
                        if (annotation instanceof Param) {
                            name = ((Param)annotation).value();
                        }
                        if (annotation instanceof LifecircleEncrypt) {
                            encryptTypeValue = ((LifecircleEncrypt)annotation).value();
                        }
                        if (!StrUtil.isNotBlank((CharSequence)name) || !StrUtil.isNotBlank((CharSequence)encryptTypeValue)) continue;
                        map.put(className + "." + methodName + "." + name, encryptTypeValue);
                    }
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return map;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

