/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.util;

import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

public class ConfigUtil {
    public static String getProperty(String el, ApplicationContext ctx) {
        if (ConfigUtil.isDynamicProperty(el)) {
            String result = ctx.getEnvironment().resolvePlaceholders(el);
            return ConfigUtil.isDynamicProperty(result) ? null : result;
        }
        return el;
    }

    private static boolean isDynamicProperty(String key) {
        if (StringUtils.startsWithIgnoreCase((String)key, (String)"#{") && StringUtils.endsWithIgnoreCase((String)key, (String)"}")) {
            return true;
        }
        return StringUtils.startsWithIgnoreCase((String)key, (String)"${") && StringUtils.endsWithIgnoreCase((String)key, (String)"}");
    }

    private static String getDynamicPropertyKey(String key) {
        return key.substring(2, key.length() - 1);
    }

    public static String getDynamicKey(String key) {
        if (ConfigUtil.isDynamicProperty(key)) {
            return ConfigUtil.getDynamicPropertyKey(key);
        }
        return key;
    }
}

