package com.fshows.yeepay.sdk.response.order.item;

import lombok.Data;

import java.math.BigDecimal;

/**
 * 渠道侧优惠列表
 * @author liangyuanping
 * @version YopChannelPromotionInfoItemResponse.java, v 0.1 2023-04-20 10:26 AM
 */
@Data
public class YopChannelPromotionInfoItemResponse {

    /**
     * 优惠券编码
     *
     * (选填)
     */
    private String promotionId;

    /**
     * 优惠券名称
     *
     * (选填)
     */
    private String promotionName;

    /**
     * 优惠券范围(全场、单品)
     *
     * (选填)
     */
    private String promotionScope;

    /**
     * 优惠券金额
     *
     * (选填)
     */
    private BigDecimal amount;

    /**
     * -
     *
     * (选填)
     */
    private BigDecimal amountRefund;

    /**
     * 优惠券活动id
     *
     * (选填)
     */
    private String activityId;

    /**
     * 渠道出资
     *
     * (选填)
     */
    private String channelContribute;

    /**
     * 商户出资
     *
     * (选填)
     */
    private String merchantContribute;

    /**
     * 其他出资
     *
     * (选填)
     */
    private String otherContribute;

    /**
     * 备注信息
     *
     * (选填)
     */
    private String memo;
}