/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.yeepay.sdk.response.order;

import lombok.Data;

import java.io.Serializable;

/**
 *
 *
 * @author
 * @version YopTradeRefundResponse.java, v 0.1 2023-04-20 11:43:08
 */
@Data
public class YopTradeRefundResponse implements Serializable {

    private static final long serialVersionUID = -2213838555316035904L;


    /**
     * 返回码，OPR00000表示易宝受理成功，退款状态请以"status"为准(示例值：OPR00000)
     *
     * (选填)
     */
    private String code;

    /**
     * 返回信息<br><p>信息描述，对应code的中文信息</p>(示例值：成功)
     *
     * (选填)
     */
    private String message;

    /**
     * 商户编号(示例值：10012426723)
     *
     * (选填)
     */
    private String merchantNo;

    /**
     * 商户收款请求号(示例值：10012016120700000000000000565)
     *
     * (选填)
     */
    private String orderId;

    /**
     * 商户退款请求号(示例值：refundorder987654)
     *
     * (选填)
     */
    private String refundRequestId;

    /**
     * 易宝退款订单号<br>商户退款请求对应在易宝的退款单号(示例值：10022022030600000003302144723)
     *
     * (选填)
     */
    private String uniqueRefundNo;

    /**
     * 退款订单状态<br>PROCESSING：退款处理中<br>SUCCESS：退款成功<br>FAILED：退款失败<br>CANCEL:退款关闭,商户通知易宝结束该笔退款后返回该状态<br>SUSPEND:退款中断,如需继续退款,请调用<a href="https://open.yeepay.com/docs/apis/ptssfk/jiaoyi/options__rest__v1.0__trade__refund__supply">上送卡信息退款</a>进行打款退款;如想结束退款,请调用<a href="https://open.yeepay.com/docs/apis/ptssfk/jiaoyi/options__rest__v1.0__trade__refund__end">结束退款</a>来关闭退款订单<br>说明:调用<a href="https://open.yeepay.com/docs/apis/bzshsfk/jiaoyi/options__rest__v1.0__trade__refund__fast">申请极速退款</a>、<a href="https://open.yeepay.com/docs/apis/bzshsfk/jiaoyi/options__rest__v1.0__trade__refund__supply">上送卡信息退款</a>、<a href="https://open.yeepay.com/docs/apis/bzshsfk/jiaoyi/options__rest__v1.0__trade__refund__end">结束退款</a>前,请联系易宝提前开通相应的退款服务。(示例值：SUCCESS)
     *
     * (选填)
     */
    private String status;

    /**
     * 退款申请金额(示例值：88.88)
     *
     * (选填)
     */
    private String refundAmount;

    /**
     * 退款受理时间(示例值：2021-01-01 00:00:00)
     *
     * (选填)
     */
    private String refundRequestDate;

    /**
     * 退还商户手续费，在退款成功时返回
     *
     * (选填)
     */
    private String refundMerchantFee;

    /**
     * 退款资金来源信息<br>debitAmount：扣账金额<br>accountType：扣账资金来源<br>扣账资金来源枚举值：<br>FUND_ACCOUNT：资金账户余额<br>DIVIDE_ACCOUNT：分账账户余额<br>SETTLE_ACCOUNT：待结算账户余额(示例值：[{"accountType":"FUND_ACCOUNT","debitAmount":6.00}])
     *
     * (选填)
     */
    private String refundAccountDetail;

}