/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.yeepay.sdk.support;

import com.google.common.collect.Lists;
import com.yeepay.g3.sdk.yop.config.CertConfig;
import com.yeepay.g3.sdk.yop.config.CertStoreType;
import com.yeepay.g3.sdk.yop.config.SDKConfig;
import com.yeepay.g3.sdk.yop.config.provider.BaseFixedAppSdkConfigProvider;
import com.yeepay.g3.sdk.yop.encrypt.CertTypeEnum;
import java.util.ArrayList;
import java.util.List;

public class CustomSdkConfigProvider
extends BaseFixedAppSdkConfigProvider {
    private static String YOP_PUBLIC_KEY;
    private static String YOP_PREFIX_URL;
    private static String APPID;

    protected List<SDKConfig> loadCustomSdkConfig() {
        ArrayList sdkConfigs = Lists.newArrayList();
        SDKConfig sdkConfig = new SDKConfig();
        sdkConfig.setAppKey(APPID);
        sdkConfig.setServerRoot(YOP_PREFIX_URL);
        CertConfig certConfig = new CertConfig();
        CertTypeEnum certTypeEnum = CertTypeEnum.RSA2048;
        certConfig.setCertType(certTypeEnum);
        CertStoreType certStoreType = CertStoreType.STRING;
        certConfig.setStoreType(certStoreType);
        certConfig.setValue(YOP_PUBLIC_KEY);
        CertConfig[] yopPublicKey = new CertConfig[]{certConfig};
        sdkConfig.setYopPublicKey(yopPublicKey);
        sdkConfig.setConnectTimeout(Integer.valueOf(10000));
        sdkConfig.setReadTimeout(Integer.valueOf(30000));
        sdkConfigs.add(sdkConfig);
        return sdkConfigs;
    }

    public CustomSdkConfigProvider() {
    }

    public CustomSdkConfigProvider(String yopPrefixUrl, String yopPublicKey, String appid) {
        YOP_PREFIX_URL = yopPrefixUrl;
        YOP_PUBLIC_KEY = yopPublicKey;
        APPID = appid;
    }
}

