/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.umpay.sdk.response.trade.pay.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 支付宝优惠券的其他出资方明细
 *
 * @author liluqing
 * @version UmpayOtherContributeDetailResponse.java, v 0.1 2022-03-16 12:11
 */
@Data
public class UmpayOtherContributeDetailResponse implements Serializable {

    private static final long serialVersionUID = -2213838555773263013L;

    /**
     * 出资方类型，如品牌商出资、支付宝平台出资等
     * <p>
     * (选填)
     */
    @Length(max = 32, message = "contributeType长度不能超过32")
    private String contributeType;

    /**
     * 出资方金额
     * <p>
     * (选填)
     */
    private BigDecimal contributeAmount;

}