/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.response.fund;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 提现权限开通
 *
 * @author
 * @version UmpayDrawApplyOpenResponse.java, v 0.1 2022-03-16 16:34:54
 */
@Data
public class UmpayDrawApplyOpenResponse implements Serializable {

    private static final long serialVersionUID = -2213838555144697692L;


    /**
     * 开通结果：0-未开通；1-已开通
     *
     * (必填)
     */
    @NotNull
    private Integer resResult;

    /**
     * 返回信息
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 255, message = "resMsg长度不能超过255")
    private String resMsg;

}