/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.prepaycard;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.prepaycard.UmpayPrepayCardBalanceQueryResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

/**
 * 预付卡余额查询
 *
 * @author linzy
 * @version UmpayPrepayCardBalanceQueryRequest.java, v 0.1 2022-07-25 16:31:35
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UmpayPrepayCardBalanceQueryRequest extends UmBizRequest<UmpayPrepayCardBalanceQueryResponse> {

    private static final long serialVersionUID = 792265624211084013L;

    /**
     * 预付卡卡号
     */
    @Length(max = 32, message = "预付卡卡号长度不能超过32")
    private String prepayCardNo;

    @Override
    public Class<UmpayPrepayCardBalanceQueryResponse> getResponseClass() {
        return UmpayPrepayCardBalanceQueryResponse.class;
    }
}