/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.merchant.wx;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.merchant.wx.UmpayWxPayConfigResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 *
 *
 * @author
 * @version UmpayWxPayConfigRequest.java, v 0.1 2022-03-16 16:00:09
 */
@Data
public class UmpayWxPayConfigRequest extends UmBizRequest<UmpayWxPayConfigResponse> {

    private static final long serialVersionUID = -2213838555624339016L;


    /**
     * 聚合收单平台为商户分配的唯一id, 商户入驻成功后由平台返回
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "storeId长度不能超过64")
    private String storeId;

    /**
     * 支付授权目录，要求符合URI格式规范jsapi_path,sub_appid,subscribe_appid，三个至少传一个
     *
     * (特殊必填)
     */
    @Length(max = 256, message = "jsapiPath长度不能超过256")
    private String jsapiPath;

    /**
     * 需要绑定的APPID，绑定微信子商户或渠道公众号、小程序对应的APPID。绑定时会对主体一致性做校验
     *
     * (特殊必填)
     */
    @Length(max = 32, message = "subAppid长度不能超过32")
    private String subAppid;

    /**
     * 推荐关注公众号APPID，该功能暂不支持
     *
     * (特殊必填)
     */
    @Length(max = 32, message = "subscribeAppid长度不能超过32")
    private String subscribeAppid;

    /**
     * 支付类型:3-微信公众号/小程序支付
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 2, message = "payType长度不能超过2")
    private String payType;

    /**
     * 微信子商户号注意：单个store_id如果做了多次微信签约，则该字段必填
     *
     * (特殊必填)
     */
    @Length(max = 32, message = "subMchId长度不能超过32")
    private String subMchId;

    @Override
    public Class<UmpayWxPayConfigResponse> getResponseClass() {
        return UmpayWxPayConfigResponse.class;
    }
}